/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.runners.worker.AvroSinkFactory;
import com.google.cloud.dataflow.sdk.runners.worker.PubsubSink;
import com.google.cloud.dataflow.sdk.runners.worker.ShuffleSinkFactory;
import com.google.cloud.dataflow.sdk.runners.worker.TextSinkFactory;
import com.google.cloud.dataflow.sdk.runners.worker.WindmillSink;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.ExecutionContext;
import com.google.cloud.dataflow.sdk.util.InstanceBuilder;
import com.google.cloud.dataflow.sdk.util.Serializer;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.Sink;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import java.util.HashMap;
import java.util.Map;

public final class SinkFactory {
    static Map<String, String> predefinedSinkFactories = new HashMap<String, String>();

    private SinkFactory() {
    }

    public static <T> Sink<T> create(PipelineOptions options, com.google.api.services.dataflow.model.Sink cloudSink, ExecutionContext executionContext, CounterSet.AddCounterMutator addCounterMutator) throws Exception {
        Coder coder = Serializer.deserialize(cloudSink.getCodec(), Coder.class);
        CloudObject object = CloudObject.fromSpec(cloudSink.getSpec());
        String className = predefinedSinkFactories.get(object.getClassName());
        if (className == null) {
            className = object.getClassName();
        }
        try {
            return (Sink)InstanceBuilder.ofType(new TypeDescriptor<Sink<T>>(){}).fromClassName(className).fromFactoryMethod("create").withArg(PipelineOptions.class, options).withArg(CloudObject.class, object).withArg(Coder.class, coder).withArg(ExecutionContext.class, executionContext).withArg(CounterSet.AddCounterMutator.class, addCounterMutator).build();
        }
        catch (ClassNotFoundException exn) {
            String string = String.valueOf(cloudSink);
            throw new Exception(new StringBuilder(29 + String.valueOf(string).length()).append("unable to create a sink from ").append(string).toString(), exn);
        }
    }

    static {
        predefinedSinkFactories.put("TextSink", TextSinkFactory.class.getName());
        predefinedSinkFactories.put("AvroSink", AvroSinkFactory.class.getName());
        predefinedSinkFactories.put("ShuffleSink", ShuffleSinkFactory.class.getName());
        predefinedSinkFactories.put("PubsubSink", PubsubSink.class.getName());
        predefinedSinkFactories.put("WindmillSink", WindmillSink.class.getName());
    }
}

