/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.cache.Weigher;
import com.google.cloud.dataflow.sdk.util.Sized;

class SizedWeigher<K, V>
implements Weigher<K, Sized<V>> {
    private final int baseWeight;

    public SizedWeigher(int baseWeight) {
        Preconditions.checkArgument(baseWeight > 0, "base weight for SizedWeigher must be positive");
        this.baseWeight = baseWeight;
    }

    @Override
    public int weigh(K key, Sized<V> value) {
        return this.baseWeight + (int)Math.min(value.getSize(), Integer.MAX_VALUE);
    }
}

