/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.cloud.dataflow.sdk.runners.worker.KeyedWorkItem;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.util.ReshuffleTrigger;
import com.google.cloud.dataflow.sdk.util.SystemDoFnInternal;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.KV;
import java.util.Collections;

@SystemDoFnInternal
public class StreamingGroupAlsoByWindowsReshuffleDoFn<K, T>
extends DoFn<KeyedWorkItem<T>, KV<K, Iterable<T>>> {
    public static boolean isReshuffle(WindowingStrategy<?, ?> strategy) {
        return strategy.getTrigger().getSpec() instanceof ReshuffleTrigger;
    }

    @Override
    public void processElement(DoFn.ProcessContext c) throws Exception {
        Object key = ((KeyedWorkItem)c.element()).key();
        for (WindowedValue item : ((KeyedWorkItem)c.element()).elementsIterable()) {
            c.windowingInternals().outputWindowedValue(KV.of(key, Collections.singletonList(item.getValue())), item.getTimestamp(), item.getWindows(), item.getPane());
        }
    }
}

