/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.io.TextIO;
import com.google.cloud.dataflow.sdk.runners.worker.CopyableSeekableByteChannel;
import com.google.cloud.dataflow.sdk.runners.worker.FileBasedReader;
import com.google.cloud.dataflow.sdk.runners.worker.LazyMultiReaderIterator;
import com.google.cloud.dataflow.sdk.util.IOChannelFactory;
import com.google.cloud.dataflow.sdk.util.common.worker.ProgressTracker;
import com.google.cloud.dataflow.sdk.util.common.worker.ProgressTrackerGroup;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;

public class TextReader<T>
extends FileBasedReader<T> {
    final boolean stripTrailingNewlines;
    final TextIO.CompressionType compressionType;

    public TextReader(String filename, boolean stripTrailingNewlines, @Nullable Long startPosition, @Nullable Long endPosition, Coder<T> coder, TextIO.CompressionType compressionType) {
        this(filename, stripTrailingNewlines, startPosition, endPosition, coder, true, compressionType);
    }

    protected TextReader(String filename, boolean stripTrailingNewlines, @Nullable Long startPosition, @Nullable Long endPosition, Coder<T> coder, boolean useDefaultBufferSize, TextIO.CompressionType compressionType) {
        super(filename, startPosition, endPosition, coder, useDefaultBufferSize);
        this.stripTrailingNewlines = stripTrailingNewlines;
        this.compressionType = compressionType;
    }

    @Override
    protected Reader.ReaderIterator<T> newReaderIteratorForRangeInFile(IOChannelFactory factory, String oneFile, long startPosition, @Nullable Long endPosition) throws IOException {
        long start = startPosition > 0L ? startPosition - 1L : 0L;
        TextFileIterator iterator = this.newReaderIteratorForRangeWithStrictStart(factory, oneFile, this.stripTrailingNewlines, start, endPosition);
        if (startPosition > 0L) {
            iterator.hasNextImpl();
        }
        return iterator;
    }

    @Override
    protected Reader.ReaderIterator<T> newReaderIteratorForFiles(IOChannelFactory factory, Collection<String> files) throws IOException {
        if (files.size() == 1) {
            return this.newReaderIteratorForFile(factory, files.iterator().next(), this.stripTrailingNewlines);
        }
        return new TextFileMultiIterator(factory, files.iterator(), this.stripTrailingNewlines);
    }

    private TextFileIterator newReaderIteratorForFile(IOChannelFactory factory, String input, boolean stripTrailingNewlines) throws IOException {
        return this.newReaderIteratorForRangeWithStrictStart(factory, input, stripTrailingNewlines, 0L, null);
    }

    private TextFileIterator newReaderIteratorForRangeWithStrictStart(IOChannelFactory factory, String input, boolean stripTrailingNewlines, long startOffset, @Nullable Long endOffset) throws IOException {
        ReadableByteChannel reader = factory.open(input);
        if (!(reader instanceof SeekableByteChannel)) {
            String string = String.valueOf(input);
            throw new UnsupportedOperationException(string.length() != 0 ? "Unable to seek in stream for ".concat(string) : new String("Unable to seek in stream for "));
        }
        SeekableByteChannel seeker = (SeekableByteChannel)reader;
        return new TextFileIterator(new CopyableSeekableByteChannel(seeker), stripTrailingNewlines, startOffset, endOffset, new FileBasedReader.FilenameBasedStreamFactory(input, this.compressionType));
    }

    private static class ScanState {
        private int start;
        private int pos;
        private int end;
        private byte[] buf;
        private boolean keepNewlines;
        private byte lastByteRead;
        private long totalBytesRead;

        public ScanState(int size, boolean keepNewlines) {
            this.start = 0;
            this.pos = 0;
            this.end = 0;
            this.buf = new byte[size];
            this.keepNewlines = keepNewlines;
            this.totalBytesRead = 0L;
        }

        public ScanState copy() {
            byte[] bufCopy = new byte[this.buf.length];
            System.arraycopy(this.buf, this.start, bufCopy, this.start, this.end - this.start);
            return new ScanState(this.keepNewlines, this.start, this.pos, this.end, bufCopy, this.lastByteRead, 0L);
        }

        private ScanState(boolean keepNewlines, int start, int pos, int end, byte[] buf, byte lastByteRead, long totalBytesRead) {
            this.start = start;
            this.pos = pos;
            this.end = end;
            this.buf = buf;
            this.keepNewlines = keepNewlines;
            this.lastByteRead = lastByteRead;
            this.totalBytesRead = totalBytesRead;
        }

        public boolean readBytes(PushbackInputStream stream) throws IOException {
            if (this.start < this.end) {
                return true;
            }
            if (!$assertionsDisabled && this.end > this.buf.length) {
                int n = this.end;
                int n2 = this.buf.length;
                throw new AssertionError((Object)new StringBuilder(25).append(n).append(" > ").append(n2).toString());
            }
            int bytesRead = stream.read(this.buf, this.end, this.buf.length - this.end);
            if (bytesRead == -1) {
                return false;
            }
            this.totalBytesRead += (long)bytesRead;
            this.end += bytesRead;
            return true;
        }

        public int consumeUntilSeparator(ByteArrayOutputStream out) {
            this.pos = this.start;
            while (this.pos < this.end) {
                this.lastByteRead = this.buf[this.pos];
                if (this.separatorFound()) {
                    int charsConsumed = this.pos - this.start + 1;
                    this.copyToOutputBuffer(out);
                    this.start = this.pos + 1;
                    return charsConsumed;
                }
                ++this.pos;
            }
            assert (this.pos == this.end);
            int charsConsumed = this.pos - this.start;
            out.write(this.buf, this.start, charsConsumed);
            this.start = 0;
            this.end = 0;
            this.pos = 0;
            return charsConsumed;
        }

        public boolean separatorFound() {
            return this.lastByteRead == 10 || this.lastByteRead == 13;
        }

        public byte lastByteRead() {
            return this.buf[this.pos];
        }

        private void copyToOutputBuffer(ByteArrayOutputStream out) {
            int charsCopied = this.pos - this.start;
            if (this.keepNewlines && this.separatorFound()) {
                ++charsCopied;
            }
            out.write(this.buf, this.start, charsCopied);
        }

        private int copyCharIfLinefeed(ByteArrayOutputStream out, PushbackInputStream stream) throws IOException {
            int charsConsumed = 0;
            if (this.pos + 1 < this.end) {
                if (this.buf[this.pos + 1] == 10) {
                    ++charsConsumed;
                    ++this.pos;
                    ++this.start;
                    if (this.keepNewlines) {
                        out.write(10);
                    }
                }
            } else {
                int b = stream.read();
                if (b == 10) {
                    ++charsConsumed;
                    ++this.totalBytesRead;
                    if (this.keepNewlines) {
                        out.write(b);
                    }
                } else if (b != -1) {
                    stream.unread(b);
                }
            }
            return charsConsumed;
        }
    }

    class TextFileIterator
    extends FileBasedReader.FileBasedIterator {
        private final boolean stripTrailingNewlines;
        private ScanState state;

        TextFileIterator(CopyableSeekableByteChannel seeker, boolean stripTrailingNewlines, @Nullable long startOffset, Long endOffset, FileBasedReader.DecompressingStreamFactory compressionStreamFactory) throws IOException {
            this(seeker, stripTrailingNewlines, startOffset, startOffset, endOffset, new ProgressTrackerGroup<Integer>(){

                @Override
                protected void report(Integer lineLength) {
                    TextReader.this.notifyElementRead(lineLength.longValue());
                }
            }.start(), new ScanState(200, !stripTrailingNewlines), compressionStreamFactory);
        }

        private TextFileIterator(CopyableSeekableByteChannel seeker, boolean stripTrailingNewlines, long startOffset, @Nullable long offset, Long endOffset, ProgressTracker<Integer> tracker, ScanState state, FileBasedReader.DecompressingStreamFactory compressionStreamFactory) throws IOException {
            super(TextReader.this, seeker, startOffset, offset, endOffset, tracker, compressionStreamFactory);
            this.stripTrailingNewlines = stripTrailingNewlines;
            this.state = state;
        }

        private TextFileIterator(TextFileIterator it) throws IOException {
            this(it.seeker.copy(), it.stripTrailingNewlines, it.rangeTracker.getStartPosition() + it.state.totalBytesRead, it.offset, it.rangeTracker.getStopPosition(), it.progressTracker.copy(), it.state.copy(), it.compressionStreamFactory);
        }

        @Override
        public Reader.ReaderIterator<T> copy() throws IOException {
            return new TextFileIterator(this);
        }

        @Override
        protected ByteArrayOutputStream readElement() throws IOException {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(200);
            int charsConsumed = 0;
            while (this.state.readBytes(this.stream)) {
                int consumed = this.state.consumeUntilSeparator(buffer);
                charsConsumed += consumed;
                if (consumed <= 0 || !this.state.separatorFound()) continue;
                if (this.state.lastByteRead() != 13) break;
                charsConsumed += this.state.copyCharIfLinefeed(buffer, this.stream);
                break;
            }
            if (charsConsumed == 0) {
                return null;
            }
            this.offset += (long)charsConsumed;
            return buffer;
        }
    }

    class TextFileMultiIterator
    extends LazyMultiReaderIterator<T> {
        private final IOChannelFactory factory;
        private final boolean stripTrailingNewlines;

        public TextFileMultiIterator(IOChannelFactory factory, Iterator<String> inputs, boolean stripTrailingNewlines) {
            super(inputs);
            this.factory = factory;
            this.stripTrailingNewlines = stripTrailingNewlines;
        }

        @Override
        protected Reader.ReaderIterator<T> open(String input) throws IOException {
            return TextReader.this.newReaderIteratorForFile(this.factory, input, this.stripTrailingNewlines);
        }
    }
}

