/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.io.TextIO;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.runners.worker.ReaderFactory;
import com.google.cloud.dataflow.sdk.runners.worker.TextReader;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.ExecutionContext;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import java.util.Map;
import javax.annotation.Nullable;

public class TextReaderFactory
implements ReaderFactory {
    private static final TextReaderFactory INSTANCE = new TextReaderFactory();

    public static TextReaderFactory getInstance() {
        return INSTANCE;
    }

    private TextReaderFactory() {
    }

    @Override
    public Reader<?> create(CloudObject spec, @Nullable Coder<?> coder, @Nullable PipelineOptions options, @Nullable ExecutionContext executionContext, @Nullable CounterSet.AddCounterMutator addCounterMutator, @Nullable String operationName) throws Exception {
        return this.create(spec, coder);
    }

    public <T> TextReader<T> create(CloudObject spec, Coder<T> coder) throws Exception {
        String filenameOrPattern = Structs.getString((Map<String, Object>)((Object)spec), "filename", null);
        if (filenameOrPattern == null) {
            filenameOrPattern = Structs.getString((Map<String, Object>)((Object)spec), "filepattern", null);
        }
        return new TextReader<T>(filenameOrPattern, Structs.getBoolean((Map<String, Object>)((Object)spec), "strip_trailing_newlines", true), Structs.getLong((Map<String, Object>)((Object)spec), "start_offset", null), Structs.getLong((Map<String, Object>)((Object)spec), "end_offset", null), coder, true, Enum.valueOf(TextIO.CompressionType.class, Structs.getString((Map<String, Object>)((Object)spec), "compression_type", "AUTO")));
    }
}

