/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.cloud.dataflow.sdk.util.common.Counter;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.StateSampler;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.util.ConcurrentHashSet;

public class UserCodeTimeTracker {
    private final Map<Long, WorkItemInfo> itemMap = new ConcurrentHashMap<Long, WorkItemInfo>();
    private final Set<Long> itemsInUserState = new ConcurrentHashSet();

    public void workStarted(String counterPrefix, long itemId, CounterSet.AddCounterMutator mutator) {
        if (this.itemMap.put(itemId, new WorkItemInfo(counterPrefix, mutator)) != null) {
            throw new IllegalArgumentException(new StringBuilder(42).append("Item ").append(itemId).append(" already started.").toString());
        }
    }

    public void workFinished(long itemId) {
        if (this.itemMap.remove(itemId) == null) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Item ").append(itemId).append(" never started.").toString());
        }
        this.itemsInUserState.remove(itemId);
    }

    public void workObservedInState(long itemId, StateSampler.StateKind kind, long elapsedMs) {
        if (kind != StateSampler.StateKind.USER) {
            this.itemsInUserState.remove(itemId);
            return;
        }
        this.itemsInUserState.add(itemId);
        WorkItemInfo info = this.itemMap.get(itemId);
        if (info == null) {
            throw new NoSuchElementException(new StringBuilder(40).append("Item ").append(itemId).append(" doesn't exist.").toString());
        }
        int numProcessors = this.getNumProcessors();
        int numActives = this.itemsInUserState.size();
        long userCodeMsecs = (long)((double)elapsedMs * Math.min(1.0, 1.0 * (double)numProcessors / (double)numActives));
        info.counter.addValue(userCodeMsecs);
    }

    public AutoCloseable scopedWork(String counterPrefix, final long itemId, CounterSet.AddCounterMutator mutator) {
        this.workStarted(counterPrefix, itemId, mutator);
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                UserCodeTimeTracker.this.workFinished(itemId);
            }
        };
    }

    protected int getNumProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static class StateSamplerCallback
    implements StateSampler.SamplingCallback {
        private final UserCodeTimeTracker tracker;
        private final long itemId;

        StateSamplerCallback(UserCodeTimeTracker tracker, long itemId) {
            this.tracker = tracker;
            this.itemId = itemId;
        }

        @Override
        public void run(int state, StateSampler.StateKind kind, long elapsedMs) {
            this.tracker.workObservedInState(this.itemId, kind, elapsedMs);
        }
    }

    private static class WorkItemInfo {
        final Counter<Long> counter;

        public WorkItemInfo(String counterPrefix, CounterSet.AddCounterMutator mutator) {
            this.counter = mutator.addCounter(Counter.longs(String.valueOf(counterPrefix).concat("user-code-msecs"), Counter.AggregationKind.SUM));
        }
    }
}

