/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.testing;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.ListCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.testing.SerializableMatcher;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.UserCodeException;
import com.google.cloud.dataflow.sdk.values.KV;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

class SerializableMatchers
implements Serializable {
    private SerializableMatchers() {
    }

    public static <T> SerializableMatcher<T> allOf(Iterable<SerializableMatcher<? super T>> serializableMatchers) {
        final Iterable<SerializableMatcher<? super T>> matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.allOf((Iterable)matchers);
            }
        });
    }

    @SafeVarargs
    public static <T> SerializableMatcher<T> allOf(final SerializableMatcher<T> ... matchers) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.allOf((Matcher[])matchers);
            }
        });
    }

    public static <T> SerializableMatcher<T> anyOf(Iterable<SerializableMatcher<? super T>> serializableMatchers) {
        final Iterable<SerializableMatcher<? super T>> matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.anyOf((Iterable)matchers);
            }
        });
    }

    @SafeVarargs
    public static <T> SerializableMatcher<T> anyOf(final SerializableMatcher<T> ... matchers) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.anyOf((Matcher[])matchers);
            }
        });
    }

    public static SerializableMatcher<Object> anything() {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Object>>(){

            @Override
            public Matcher<Object> get() {
                return Matchers.anything();
            }
        });
    }

    @SafeVarargs
    public static <T extends Serializable> SerializableMatcher<T[]> arrayContaining(final T ... items) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T[]>>(){

            @Override
            public Matcher<T[]> get() {
                return Matchers.arrayContaining((Object[])items);
            }
        });
    }

    @SafeVarargs
    public static <T> SerializableMatcher<T[]> arrayContaining(Coder<T> coder, T ... items) {
        final SerializableArrayViaCoder<T> itemsSupplier = new SerializableArrayViaCoder<T>(coder, items);
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T[]>>(){

            @Override
            public Matcher<T[]> get() {
                return Matchers.arrayContaining((Object[])((Object[])itemsSupplier.get()));
            }
        });
    }

    @SafeVarargs
    public static <T> SerializableMatcher<T[]> arrayContaining(final SerializableMatcher<? super T> ... matchers) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T[]>>(){

            @Override
            public Matcher<T[]> get() {
                return Matchers.arrayContaining((Matcher[])matchers);
            }
        });
    }

    public static <T> SerializableMatcher<T[]> arrayContaining(List<SerializableMatcher<? super T>> serializableMatchers) {
        final List<SerializableMatcher<? super T>> matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T[]>>(){

            @Override
            public Matcher<T[]> get() {
                return Matchers.arrayContaining((List)matchers);
            }
        });
    }

    @SafeVarargs
    public static <T extends Serializable> SerializableMatcher<T[]> arrayContainingInAnyOrder(final T ... items) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T[]>>(){

            @Override
            public Matcher<T[]> get() {
                return Matchers.arrayContainingInAnyOrder((Object[])items);
            }
        });
    }

    @SafeVarargs
    public static <T> SerializableMatcher<T[]> arrayContainingInAnyOrder(Coder<T> coder, T ... items) {
        final SerializableArrayViaCoder<T> itemsSupplier = new SerializableArrayViaCoder<T>(coder, items);
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T[]>>(){

            @Override
            public Matcher<T[]> get() {
                return Matchers.arrayContaining((Object[])((Object[])itemsSupplier.get()));
            }
        });
    }

    @SafeVarargs
    public static <T> SerializableMatcher<T[]> arrayContainingInAnyOrder(final SerializableMatcher<? super T> ... matchers) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T[]>>(){

            @Override
            public Matcher<T[]> get() {
                return Matchers.arrayContainingInAnyOrder((Matcher[])matchers);
            }
        });
    }

    public static <T> SerializableMatcher<T[]> arrayContainingInAnyOrder(Collection<SerializableMatcher<? super T>> serializableMatchers) {
        final Collection<SerializableMatcher<? super T>> matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T[]>>(){

            @Override
            public Matcher<T[]> get() {
                return Matchers.arrayContainingInAnyOrder((Collection)matchers);
            }
        });
    }

    public static <T> SerializableMatcher<T[]> arrayWithSize(final int size) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T[]>>(){

            @Override
            public Matcher<T[]> get() {
                return Matchers.arrayWithSize((int)size);
            }
        });
    }

    public static <T> SerializableMatcher<T[]> arrayWithSize(final SerializableMatcher<? super Integer> sizeMatcher) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T[]>>(){

            @Override
            public Matcher<T[]> get() {
                return Matchers.arrayWithSize((Matcher)sizeMatcher);
            }
        });
    }

    public static SerializableMatcher<Double> closeTo(final double target, final double error) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Double>>(){

            @Override
            public Matcher<Double> get() {
                return Matchers.closeTo((double)target, (double)error);
            }
        });
    }

    @SafeVarargs
    public static <T extends Serializable> SerializableMatcher<Iterable<? extends T>> contains(T ... items) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Iterable<? extends T>>>((Serializable[])items){
            final /* synthetic */ Serializable[] val$items;
            {
                this.val$items = serializableArray;
            }

            @Override
            public Matcher<Iterable<? extends T>> get() {
                return Matchers.contains((Object[])this.val$items);
            }
        });
    }

    @SafeVarargs
    public static <T> SerializableMatcher<Iterable<? extends T>> contains(Coder<T> coder, T ... items) {
        final SerializableArrayViaCoder<T> itemsSupplier = new SerializableArrayViaCoder<T>(coder, items);
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Iterable<? extends T>>>(){

            @Override
            public Matcher<Iterable<? extends T>> get() {
                return Matchers.containsInAnyOrder((Object[])((Object[])itemsSupplier.get()));
            }
        });
    }

    @SafeVarargs
    public static <T> SerializableMatcher<Iterable<? extends T>> contains(final SerializableMatcher<? super T> ... matchers) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Iterable<? extends T>>>(){

            @Override
            public Matcher<Iterable<? extends T>> get() {
                return Matchers.contains((Matcher[])matchers);
            }
        });
    }

    public static <T extends Serializable> SerializableMatcher<Iterable<? extends T>> contains(List<SerializableMatcher<? super T>> serializableMatchers) {
        final List<SerializableMatcher<? super T>> matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Iterable<? extends T>>>(){

            @Override
            public Matcher<Iterable<? extends T>> get() {
                return Matchers.contains((List)matchers);
            }
        });
    }

    @SafeVarargs
    public static <T extends Serializable> SerializableMatcher<Iterable<? extends T>> containsInAnyOrder(T ... items) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Iterable<? extends T>>>((Serializable[])items){
            final /* synthetic */ Serializable[] val$items;
            {
                this.val$items = serializableArray;
            }

            @Override
            public Matcher<Iterable<? extends T>> get() {
                return Matchers.containsInAnyOrder((Object[])this.val$items);
            }
        });
    }

    @SafeVarargs
    public static <T> SerializableMatcher<Iterable<? extends T>> containsInAnyOrder(Coder<T> coder, T ... items) {
        final SerializableArrayViaCoder<T> itemsSupplier = new SerializableArrayViaCoder<T>(coder, items);
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Iterable<? extends T>>>(){

            @Override
            public Matcher<Iterable<? extends T>> get() {
                return Matchers.containsInAnyOrder((Object[])((Object[])itemsSupplier.get()));
            }
        });
    }

    @SafeVarargs
    public static <T> SerializableMatcher<Iterable<? extends T>> containsInAnyOrder(final SerializableMatcher<? super T> ... matchers) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Iterable<? extends T>>>(){

            @Override
            public Matcher<Iterable<? extends T>> get() {
                return Matchers.containsInAnyOrder((Matcher[])matchers);
            }
        });
    }

    public static <T> SerializableMatcher<Iterable<? extends T>> containsInAnyOrder(Collection<SerializableMatcher<? super T>> serializableMatchers) {
        final Collection<SerializableMatcher<? super T>> matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Iterable<? extends T>>>(){

            @Override
            public Matcher<Iterable<? extends T>> get() {
                return Matchers.containsInAnyOrder((Collection)matchers);
            }
        });
    }

    public static SerializableMatcher<String> containsString(final String substring) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<String>>(){

            @Override
            public Matcher<String> get() {
                return Matchers.containsString((String)substring);
            }
        });
    }

    public static <T> SerializableMatcher<Collection<? extends T>> empty() {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Collection<? extends T>>>(){

            @Override
            public Matcher<Collection<? extends T>> get() {
                return Matchers.empty();
            }
        });
    }

    public static <T> SerializableMatcher<T[]> emptyArray() {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T[]>>(){

            @Override
            public Matcher<T[]> get() {
                return Matchers.emptyArray();
            }
        });
    }

    public static <T> SerializableMatcher<Iterable<? extends T>> emptyIterable() {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Iterable<? extends T>>>(){

            @Override
            public Matcher<Iterable<? extends T>> get() {
                return Matchers.emptyIterable();
            }
        });
    }

    public static SerializableMatcher<String> endsWith(final String substring) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<String>>(){

            @Override
            public Matcher<String> get() {
                return Matchers.endsWith((String)substring);
            }
        });
    }

    public static <T extends Serializable> SerializableMatcher<T> equalTo(final T expected) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.equalTo((Object)expected);
            }
        });
    }

    public static <T> SerializableMatcher<T> equalTo(Coder<T> coder, T expected) {
        final SerializableViaCoder<T> expectedSupplier = new SerializableViaCoder<T>(coder, expected);
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.equalTo(expectedSupplier.get());
            }
        });
    }

    public static <T extends Comparable<T> & Serializable> SerializableMatcher<T> greaterThan(final T target) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.greaterThan((Comparable)target);
            }
        });
    }

    public static <T extends Comparable<T> & Serializable> SerializableMatcher<T> greaterThan(Coder<T> coder, T target) {
        final SerializableViaCoder<T> targetSupplier = new SerializableViaCoder<T>(coder, target);
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.greaterThan((Comparable)((Comparable)targetSupplier.get()));
            }
        });
    }

    public static <T extends Comparable<T>> SerializableMatcher<T> greaterThanOrEqualTo(final T target) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.greaterThanOrEqualTo((Comparable)target);
            }
        });
    }

    public static <T extends Comparable<T> & Serializable> SerializableMatcher<T> greaterThanOrEqualTo(Coder<T> coder, T target) {
        final SerializableViaCoder<T> targetSupplier = new SerializableViaCoder<T>(coder, target);
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.greaterThanOrEqualTo((Comparable)((Comparable)targetSupplier.get()));
            }
        });
    }

    public static <T extends Serializable> SerializableMatcher<Iterable<? super T>> hasItem(final T target) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Iterable<? super T>>>(){

            @Override
            public Matcher<Iterable<? super T>> get() {
                return Matchers.hasItem((Object)target);
            }
        });
    }

    public static <T> SerializableMatcher<Iterable<? super T>> hasItem(Coder<T> coder, T target) {
        final SerializableViaCoder<T> targetSupplier = new SerializableViaCoder<T>(coder, target);
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Iterable<? super T>>>(){

            @Override
            public Matcher<Iterable<? super T>> get() {
                return Matchers.hasItem(targetSupplier.get());
            }
        });
    }

    public static <T> SerializableMatcher<Iterable<? super T>> hasItem(final SerializableMatcher<? super T> matcher) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Iterable<? super T>>>(){

            @Override
            public Matcher<Iterable<? super T>> get() {
                return Matchers.hasItem((Matcher)matcher);
            }
        });
    }

    public static <T> SerializableMatcher<Collection<? extends T>> hasSize(final int size) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Collection<? extends T>>>(){

            @Override
            public Matcher<Collection<? extends T>> get() {
                return Matchers.hasSize((int)size);
            }
        });
    }

    public static <T> SerializableMatcher<Collection<? extends T>> hasSize(final SerializableMatcher<? super Integer> sizeMatcher) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Collection<? extends T>>>(){

            @Override
            public Matcher<Collection<? extends T>> get() {
                return Matchers.hasSize((Matcher)sizeMatcher);
            }
        });
    }

    public static <T> SerializableMatcher<Iterable<T>> iterableWithSize(final int size) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Iterable<T>>>(){

            @Override
            public Matcher<Iterable<T>> get() {
                return Matchers.iterableWithSize((int)size);
            }
        });
    }

    public static <T> SerializableMatcher<Iterable<T>> iterableWithSize(final SerializableMatcher<? super Integer> sizeMatcher) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Iterable<T>>>(){

            @Override
            public Matcher<Iterable<T>> get() {
                return Matchers.iterableWithSize((Matcher)sizeMatcher);
            }
        });
    }

    public static <T extends Serializable> SerializableMatcher<T> isIn(final Collection<T> collection) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.isIn((Collection)collection);
            }
        });
    }

    public static <T> SerializableMatcher<T> isIn(Coder<T> coder, Collection<T> collection) {
        Object[] items = collection.toArray();
        final SerializableArrayViaCoder<Object> itemsSupplier = new SerializableArrayViaCoder<Object>(coder, items);
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.isIn((Object[])((Object[])itemsSupplier.get()));
            }
        });
    }

    public static <T extends Serializable> SerializableMatcher<T> isIn(T[] items) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>((Serializable[])items){
            final /* synthetic */ Serializable[] val$items;
            {
                this.val$items = serializableArray;
            }

            @Override
            public Matcher<T> get() {
                return Matchers.isIn((Object[])this.val$items);
            }
        });
    }

    public static <T> SerializableMatcher<T> isIn(Coder<T> coder, T[] items) {
        final SerializableArrayViaCoder<T> itemsSupplier = new SerializableArrayViaCoder<T>(coder, items);
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.isIn((Object[])((Object[])itemsSupplier.get()));
            }
        });
    }

    @SafeVarargs
    public static <T extends Serializable> SerializableMatcher<T> isOneOf(T ... elems) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>((Serializable[])elems){
            final /* synthetic */ Serializable[] val$elems;
            {
                this.val$elems = serializableArray;
            }

            @Override
            public Matcher<T> get() {
                return Matchers.isOneOf((Object[])this.val$elems);
            }
        });
    }

    @SafeVarargs
    public static <T> SerializableMatcher<T> isOneOf(Coder<T> coder, T ... items) {
        final SerializableArrayViaCoder<T> itemsSupplier = new SerializableArrayViaCoder<T>(coder, items);
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.isOneOf((Object[])((Object[])itemsSupplier.get()));
            }
        });
    }

    public static <K extends Serializable, V> SerializableMatcher<KV<? extends K, ? extends V>> kvWithKey(K key) {
        return new KvKeyMatcher(SerializableMatchers.equalTo(key));
    }

    public static <K, V> SerializableMatcher<KV<? extends K, ? extends V>> kvWithKey(Coder<K> coder, K key) {
        return new KvKeyMatcher(SerializableMatchers.equalTo(coder, key));
    }

    public static <K, V> SerializableMatcher<KV<? extends K, ? extends V>> kvWithKey(SerializableMatcher<? super K> keyMatcher) {
        return new KvKeyMatcher(keyMatcher);
    }

    public static <K, V extends Serializable> SerializableMatcher<KV<? extends K, ? extends V>> kvWithValue(V value) {
        return new KvValueMatcher(SerializableMatchers.equalTo(value));
    }

    public static <K, V> SerializableMatcher<KV<? extends K, ? extends V>> kvWithValue(Coder<V> coder, V value) {
        return new KvValueMatcher(SerializableMatchers.equalTo(coder, value));
    }

    public static <K, V> SerializableMatcher<KV<? extends K, ? extends V>> kvWithValue(SerializableMatcher<? super V> valueMatcher) {
        return new KvValueMatcher(valueMatcher);
    }

    public static <K, V> SerializableMatcher<KV<? extends K, ? extends V>> kv(SerializableMatcher<? super K> keyMatcher, SerializableMatcher<? super V> valueMatcher) {
        return SerializableMatchers.allOf(SerializableMatchers.kvWithKey(keyMatcher), SerializableMatchers.kvWithValue(valueMatcher));
    }

    public static <T extends Comparable<T> & Serializable> SerializableMatcher<T> lessThan(final T target) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.lessThan((Comparable)target);
            }
        });
    }

    public static <T extends Comparable<T>> SerializableMatcher<T> lessThan(Coder<T> coder, T target) {
        final SerializableViaCoder<T> targetSupplier = new SerializableViaCoder<T>(coder, target);
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.lessThan((Comparable)((Comparable)targetSupplier.get()));
            }
        });
    }

    public static <T extends Comparable<T> & Serializable> SerializableMatcher<T> lessThanOrEqualTo(final T target) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.lessThanOrEqualTo((Comparable)target);
            }
        });
    }

    public static <T extends Comparable<T>> SerializableMatcher<T> lessThanOrEqualTo(Coder<T> coder, T target) {
        final SerializableViaCoder<T> targetSupplier = new SerializableViaCoder<T>(coder, target);
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.lessThanOrEqualTo((Comparable)((Comparable)targetSupplier.get()));
            }
        });
    }

    public static <T> SerializableMatcher<T> not(final SerializableMatcher<T> matcher) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<T>>(){

            @Override
            public Matcher<T> get() {
                return Matchers.not((Matcher)matcher);
            }
        });
    }

    public static SerializableMatcher<Object> nullValue() {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<Object>>(){

            @Override
            public Matcher<Object> get() {
                return Matchers.nullValue();
            }
        });
    }

    public static SerializableMatcher<String> startsWith(final String substring) {
        return SerializableMatchers.fromSupplier(new SerializableSupplier<Matcher<String>>(){

            @Override
            public Matcher<String> get() {
                return Matchers.startsWith((String)substring);
            }
        });
    }

    public static <T> SerializableMatcher<T> fromSupplier(SerializableSupplier<Matcher<T>> supplier) {
        return new SerializableMatcherFromSupplier<T>(supplier);
    }

    private static class SerializableArrayViaCoder<T>
    implements SerializableSupplier<T[]> {
        @Nullable
        private transient T[] value;
        private byte[] encodedValue;
        private Coder<List<T>> coder;

        public SerializableArrayViaCoder(Coder<T> elementCoder, T[] value) {
            this.coder = ListCoder.of(elementCoder);
            this.value = value;
            try {
                this.encodedValue = CoderUtils.encodeToByteArray(this.coder, Arrays.asList(value));
            }
            catch (CoderException exc) {
                throw new UserCodeException(exc);
            }
        }

        @Override
        public T[] get() {
            if (this.value == null) {
                try {
                    Object[] decoded = CoderUtils.decodeFromByteArray(this.coder, this.encodedValue).toArray();
                    this.value = decoded;
                }
                catch (CoderException exc) {
                    throw new RuntimeException("Error deserializing via Coder", exc);
                }
            }
            return this.value;
        }
    }

    private static class SerializableViaCoder<T>
    implements SerializableSupplier<T> {
        @Nullable
        private transient T value;
        private byte[] encodedValue;
        private Coder<T> coder;

        public SerializableViaCoder(Coder<T> coder, T value) {
            this.coder = coder;
            this.value = value;
            try {
                this.encodedValue = CoderUtils.encodeToByteArray(coder, value);
            }
            catch (CoderException exc) {
                throw new RuntimeException("Error serializing via Coder", exc);
            }
        }

        @Override
        public T get() {
            if (this.value == null) {
                try {
                    this.value = CoderUtils.decodeFromByteArray(this.coder, this.encodedValue);
                }
                catch (CoderException exc) {
                    throw new RuntimeException("Error deserializing via Coder", exc);
                }
            }
            return this.value;
        }
    }

    private static class SerializableMatcherFromSupplier<T>
    extends BaseMatcher<T>
    implements SerializableMatcher<T> {
        private SerializableSupplier<Matcher<T>> supplier;

        public SerializableMatcherFromSupplier(SerializableSupplier<Matcher<T>> supplier) {
            this.supplier = supplier;
        }

        public void describeTo(Description description) {
            this.supplier.get().describeTo(description);
        }

        public boolean matches(Object item) {
            return this.supplier.get().matches(item);
        }

        public void describeMismatch(Object item, Description mismatchDescription) {
            this.supplier.get().describeMismatch(item, mismatchDescription);
        }
    }

    public static interface SerializableSupplier<T>
    extends Serializable {
        public T get();
    }

    private static class KvValueMatcher<K, V>
    extends BaseMatcher<KV<? extends K, ? extends V>>
    implements SerializableMatcher<KV<? extends K, ? extends V>> {
        private final SerializableMatcher<? super V> valueMatcher;

        public KvValueMatcher(SerializableMatcher<? super V> valueMatcher) {
            this.valueMatcher = valueMatcher;
        }

        public boolean matches(Object item) {
            KV kvItem = (KV)item;
            return this.valueMatcher.matches(kvItem.getValue());
        }

        public void describeMismatch(Object item, Description mismatchDescription) {
            KV kvItem = (KV)item;
            if (!this.valueMatcher.matches(kvItem.getValue())) {
                mismatchDescription.appendText("value did not match: ");
                this.valueMatcher.describeMismatch(kvItem.getValue(), mismatchDescription);
            }
        }

        public void describeTo(Description description) {
            description.appendText("KV with value matching ");
            this.valueMatcher.describeTo(description);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).addValue(this.valueMatcher).toString();
        }
    }

    private static class KvKeyMatcher<K, V>
    extends BaseMatcher<KV<? extends K, ? extends V>>
    implements SerializableMatcher<KV<? extends K, ? extends V>> {
        private final SerializableMatcher<? super K> keyMatcher;

        public KvKeyMatcher(SerializableMatcher<? super K> keyMatcher) {
            this.keyMatcher = keyMatcher;
        }

        public boolean matches(Object item) {
            KV kvItem = (KV)item;
            return this.keyMatcher.matches(kvItem.getKey());
        }

        public void describeMismatch(Object item, Description mismatchDescription) {
            KV kvItem = (KV)item;
            if (!this.keyMatcher.matches(kvItem.getKey())) {
                mismatchDescription.appendText("key did not match: ");
                this.keyMatcher.describeMismatch(kvItem.getKey(), mismatchDescription);
            }
        }

        public void describeTo(Description description) {
            description.appendText("KV with key matching ");
            this.keyMatcher.describeTo(description);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).addValue(this.keyMatcher).toString();
        }
    }
}

