/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.testing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.PipelineResult;
import com.google.cloud.dataflow.sdk.options.ApplicationNameOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsFactory;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Optional;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterators;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.UnmodifiableIterator;
import com.google.cloud.dataflow.sdk.runners.DirectPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.PipelineRunner;
import com.google.cloud.dataflow.sdk.testing.TestDataflowPipelineOptions;
import com.google.cloud.dataflow.sdk.testing.TestDataflowPipelineRunner;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPipeline
extends Pipeline {
    private static final String PROPERTY_DATAFLOW_OPTIONS = "dataflowOptions";
    private static final Logger LOG = LoggerFactory.getLogger(TestPipeline.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static TestPipeline create() {
        if (Boolean.parseBoolean(System.getProperty("runIntegrationTestOnService"))) {
            TestDataflowPipelineOptions options = TestPipeline.getPipelineOptions();
            String string = String.valueOf(options);
            LOG.info(new StringBuilder(25 + String.valueOf(string).length()).append("Using passed in options: ").append(string).toString());
            options.setStableUniqueNames(PipelineOptions.CheckEnabled.ERROR);
            return new TestPipeline(TestDataflowPipelineRunner.fromOptions(options), (PipelineOptions)options);
        }
        DirectPipelineRunner directRunner = DirectPipelineRunner.createForTest();
        directRunner.getPipelineOptions().setAppName(TestPipeline.getAppName());
        directRunner.getPipelineOptions().setStableUniqueNames(PipelineOptions.CheckEnabled.ERROR);
        return new TestPipeline(directRunner, (PipelineOptions)directRunner.getPipelineOptions());
    }

    private TestPipeline(PipelineRunner<? extends PipelineResult> runner, PipelineOptions options) {
        super(runner, options);
    }

    @Override
    public PipelineResult run() {
        try {
            return super.run();
        }
        catch (RuntimeException exc) {
            Throwable cause = exc.getCause();
            if (cause instanceof AssertionError) {
                throw (AssertionError)((Object)cause);
            }
            throw exc;
        }
    }

    @Override
    public String toString() {
        String string = String.valueOf(this.getOptions().as(ApplicationNameOptions.class).getAppName());
        return string.length() != 0 ? "TestPipeline#".concat(string) : new String("TestPipeline#");
    }

    static TestDataflowPipelineOptions getPipelineOptions() {
        try {
            TestDataflowPipelineOptions options = PipelineOptionsFactory.fromArgs((String[])MAPPER.readValue(System.getProperty(PROPERTY_DATAFLOW_OPTIONS), String[].class)).as(TestDataflowPipelineOptions.class);
            options.setAppName(TestPipeline.getAppName());
            return options;
        }
        catch (IOException e) {
            String string = String.valueOf("Unable to instantiate test options from system property dataflowOptions:");
            String string2 = String.valueOf(System.getProperty(PROPERTY_DATAFLOW_OPTIONS));
            throw new RuntimeException(string2.length() != 0 ? string.concat(string2) : new String(string), e);
        }
    }

    private static String getAppName() {
        Optional<StackTraceElement> stackTraceElement = TestPipeline.findCallersStackTrace();
        if (stackTraceElement.isPresent()) {
            String methodName = stackTraceElement.get().getMethodName();
            String className = stackTraceElement.get().getClassName();
            if (className.contains(".")) {
                className = className.substring(className.lastIndexOf(".") + 1);
            }
            String string = className;
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(methodName).length()).append(string).append("-").append(methodName).toString();
        }
        return "UnitTest";
    }

    private static Optional<StackTraceElement> findCallersStackTrace() {
        StackTraceElement next;
        UnmodifiableIterator<StackTraceElement> elements = Iterators.forArray(Thread.currentThread().getStackTrace());
        while (elements.hasNext()) {
            next = (StackTraceElement)elements.next();
            if (!TestPipeline.class.getName().equals(next.getClassName())) continue;
            break;
        }
        while (elements.hasNext()) {
            next = (StackTraceElement)elements.next();
            if (TestPipeline.class.getName().equals(next.getClassName())) continue;
            return Optional.of(next);
        }
        return Optional.absent();
    }
}

