/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Function;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Throwables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.FluentIterable;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.reflect.TypeParameter;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.reflect.TypeToken;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.DoFnWithContext;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.PaneInfo;
import com.google.cloud.dataflow.sdk.util.UserCodeException;
import com.google.cloud.dataflow.sdk.util.WindowingInternals;
import com.google.cloud.dataflow.sdk.util.common.ReflectHelpers;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.Instant;

public abstract class DoFnReflector {
    private static final Map<Class<?>, ExtraContextInfo> EXTRA_CONTEXTS = Collections.emptyMap();
    private static final Map<Class<?>, ExtraContextInfo> EXTRA_PROCESS_CONTEXTS = ImmutableMap.builder().putAll(EXTRA_CONTEXTS).put(BoundedWindow.class, new ExtraContextInfo(){

        @Override
        public <InputT, OutputT> Object createInstance(DoFnWithContext.ExtraContextFactory<InputT, OutputT> factory) {
            return factory.window();
        }

        @Override
        public <InputT, OutputT> TypeToken<?> tokenFor(TypeToken<InputT> in, TypeToken<OutputT> out) {
            return TypeToken.of(BoundedWindow.class);
        }
    }).put(WindowingInternals.class, new ExtraContextInfo(){

        @Override
        public <InputT, OutputT> Object createInstance(DoFnWithContext.ExtraContextFactory<InputT, OutputT> factory) {
            return factory.windowingInternals();
        }

        @Override
        public <InputT, OutputT> TypeToken<?> tokenFor(TypeToken<InputT> in, TypeToken<OutputT> out) {
            return new TypeToken<WindowingInternals<InputT, OutputT>>(){}.where(new TypeParameter<InputT>(){}, in).where(new TypeParameter<OutputT>(){}, out);
        }
    }).build();
    private static final Map<Class<?>, DoFnReflector> REFLECTOR_CACHE = new LinkedHashMap();

    public abstract boolean usesSingleWindow();

    abstract <InputT, OutputT> void invokeProcessElement(DoFnWithContext<InputT, OutputT> var1, DoFnWithContext.ProcessContext var2, DoFnWithContext.ExtraContextFactory<InputT, OutputT> var3);

    abstract <InputT, OutputT> void invokeStartBundle(DoFnWithContext<InputT, OutputT> var1, DoFnWithContext.Context var2, DoFnWithContext.ExtraContextFactory<InputT, OutputT> var3);

    abstract <InputT, OutputT> void invokeFinishBundle(DoFnWithContext<InputT, OutputT> var1, DoFnWithContext.Context var2, DoFnWithContext.ExtraContextFactory<InputT, OutputT> var3);

    public static DoFnReflector of(Class<? extends DoFnWithContext> fn) {
        DoFnReflector reflector = REFLECTOR_CACHE.get(fn);
        if (reflector != null) {
            return reflector;
        }
        reflector = new GenericDoFnReflector(fn);
        REFLECTOR_CACHE.put(fn, reflector);
        return reflector;
    }

    public <InputT, OutputT> DoFn<InputT, OutputT> toDoFn(DoFnWithContext<InputT, OutputT> fn) {
        if (this.usesSingleWindow()) {
            return new WindowDoFnAdapter(this, fn);
        }
        return new SimpleDoFnAdapter(this, fn);
    }

    private static String formatType(TypeToken<?> t) {
        return ReflectHelpers.TYPE_SIMPLE_DESCRIPTION.apply(t.getType());
    }

    private static String format(Method m) {
        return ReflectHelpers.CLASS_AND_METHOD_FORMATTER.apply(m);
    }

    private static Collection<String> describeSupportedTypes(Map<Class<?>, ExtraContextInfo> extraProcessContexts, final TypeToken<?> in, final TypeToken<?> out) {
        return FluentIterable.from(extraProcessContexts.values()).transform(new Function<ExtraContextInfo, String>(){

            @Override
            @Nullable
            public String apply(@Nullable ExtraContextInfo input) {
                if (input == null) {
                    return null;
                }
                return DoFnReflector.formatType(input.tokenFor(in, out));
            }
        }).toSortedSet(String.CASE_INSENSITIVE_ORDER);
    }

    @VisibleForTesting
    static <InputT, OutputT> ExtraContextInfo[] verifyProcessMethodArguments(Method m) {
        return DoFnReflector.verifyMethodArguments(m, EXTRA_PROCESS_CONTEXTS, new TypeToken<DoFnWithContext.ProcessContext>(){}, new TypeParameter<InputT>(){}, new TypeParameter<OutputT>(){});
    }

    @VisibleForTesting
    static <InputT, OutputT> ExtraContextInfo[] verifyBundleMethodArguments(Method m) {
        return DoFnReflector.verifyMethodArguments(m, EXTRA_CONTEXTS, new TypeToken<DoFnWithContext.Context>(){}, new TypeParameter<InputT>(){}, new TypeParameter<OutputT>(){});
    }

    @VisibleForTesting
    static <InputT, OutputT> ExtraContextInfo[] verifyMethodArguments(Method m, Map<Class<?>, ExtraContextInfo> contexts, TypeToken<?> firstContextArg, TypeParameter<InputT> iParam, TypeParameter<OutputT> oParam) {
        if (!Void.TYPE.equals(m.getReturnType())) {
            throw new IllegalStateException(String.format("%s must have a void return type", DoFnReflector.format(m)));
        }
        if (m.isVarArgs()) {
            throw new IllegalStateException(String.format("%s must not have var args", DoFnReflector.format(m)));
        }
        Type[] params = m.getGenericParameterTypes();
        TypeToken<?> contextToken = null;
        if (params.length > 0) {
            contextToken = TypeToken.of(params[0]);
        }
        if (contextToken == null || !contextToken.getRawType().equals(firstContextArg.getRawType())) {
            throw new IllegalStateException(String.format("%s must take a %s as its first argument", DoFnReflector.format(m), firstContextArg.getRawType().getSimpleName()));
        }
        ExtraContextInfo[] contextInfos = new ExtraContextInfo[params.length - 1];
        ParameterizedType pt = (ParameterizedType)contextToken.getType();
        pt = (ParameterizedType)pt.getOwnerType();
        TypeToken<?> iActual = TypeToken.of(pt.getActualTypeArguments()[0]);
        TypeToken<?> oActual = TypeToken.of(pt.getActualTypeArguments()[1]);
        for (int i = 1; i < params.length; ++i) {
            TypeToken<?> param = TypeToken.of(params[i]);
            ExtraContextInfo info = contexts.get(param.getRawType());
            if (info == null) {
                throw new IllegalStateException(String.format("%s is not a valid context parameter for method %s. Should be one of %s", DoFnReflector.formatType(param), DoFnReflector.format(m), DoFnReflector.describeSupportedTypes(contexts, iActual, oActual)));
            }
            TypeToken<?> expected = info.tokenFor(iActual, oActual);
            if (!DoFnReflector.isSupertypeOf(param, expected)) {
                throw new IllegalStateException(String.format("Incompatible generics in context parameter %s for method %s. Should be %s", DoFnReflector.formatType(param), DoFnReflector.format(m), DoFnReflector.formatType(info.tokenFor(iActual, oActual))));
            }
            contextInfos[i - 1] = info;
        }
        return contextInfos;
    }

    private static boolean isSupertypeOf(TypeToken<?> param, TypeToken<?> expected) {
        return param.isAssignableFrom(expected);
    }

    public static Class<?> getDoFnClass(DoFn<?, ?> fn) {
        if (fn instanceof SimpleDoFnAdapter) {
            return ((SimpleDoFnAdapter)fn).fn.getClass();
        }
        return fn.getClass();
    }

    private static class WindowDoFnAdapter<InputT, OutputT>
    extends SimpleDoFnAdapter<InputT, OutputT>
    implements DoFn.RequiresWindowAccess {
        private WindowDoFnAdapter(DoFnReflector reflector, DoFnWithContext<InputT, OutputT> fn) {
            super(reflector, fn);
        }
    }

    private static class SimpleDoFnAdapter<InputT, OutputT>
    extends DoFn<InputT, OutputT> {
        private transient DoFnReflector reflector;
        private DoFnWithContext<InputT, OutputT> fn;

        private SimpleDoFnAdapter(DoFnReflector reflector, DoFnWithContext<InputT, OutputT> fn) {
            super(fn.aggregators);
            this.reflector = reflector;
            this.fn = fn;
        }

        @Override
        public void startBundle(DoFn.Context c) throws Exception {
            ContextAdapter adapter = new ContextAdapter(this.fn, c);
            this.reflector.invokeStartBundle(this.fn, adapter, adapter);
        }

        @Override
        public void finishBundle(DoFn.Context c) throws Exception {
            ContextAdapter adapter = new ContextAdapter(this.fn, c);
            this.reflector.invokeFinishBundle(this.fn, adapter, adapter);
        }

        @Override
        public void processElement(DoFn.ProcessContext c) throws Exception {
            ProcessContextAdapter adapter = new ProcessContextAdapter(this.fn, c);
            this.reflector.invokeProcessElement(this.fn, adapter, adapter);
        }

        @Override
        protected TypeDescriptor<InputT> getInputTypeDescriptor() {
            return this.fn.getInputTypeDescriptor();
        }

        @Override
        protected TypeDescriptor<OutputT> getOutputTypeDescriptor() {
            return this.fn.getOutputTypeDescriptor();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.reflector = DoFnReflector.of(this.fn.getClass());
        }
    }

    private static class ProcessContextAdapter<InputT, OutputT>
    extends DoFnWithContext.ProcessContext
    implements DoFnWithContext.ExtraContextFactory<InputT, OutputT> {
        private DoFn.ProcessContext context;

        private ProcessContextAdapter(DoFnWithContext<InputT, OutputT> fn, DoFn.ProcessContext context) {
            super(fn);
            this.context = context;
        }

        @Override
        public PipelineOptions getPipelineOptions() {
            return this.context.getPipelineOptions();
        }

        @Override
        public <T> T sideInput(PCollectionView<T> view) {
            return this.context.sideInput(view);
        }

        @Override
        public void output(OutputT output) {
            this.context.output(output);
        }

        @Override
        public void outputWithTimestamp(OutputT output, Instant timestamp) {
            this.context.outputWithTimestamp(output, timestamp);
        }

        @Override
        public <T> void sideOutput(TupleTag<T> tag, T output) {
            this.context.sideOutput(tag, output);
        }

        @Override
        public <T> void sideOutputWithTimestamp(TupleTag<T> tag, T output, Instant timestamp) {
            this.context.sideOutputWithTimestamp(tag, output, timestamp);
        }

        @Override
        public InputT element() {
            return this.context.element();
        }

        @Override
        public Instant timestamp() {
            return this.context.timestamp();
        }

        @Override
        public PaneInfo pane() {
            return this.context.pane();
        }

        @Override
        public BoundedWindow window() {
            return this.context.window();
        }

        @Override
        public WindowingInternals<InputT, OutputT> windowingInternals() {
            return this.context.windowingInternals();
        }
    }

    private static class ContextAdapter<InputT, OutputT>
    extends DoFnWithContext.Context
    implements DoFnWithContext.ExtraContextFactory<InputT, OutputT> {
        private DoFn.Context context;

        private ContextAdapter(DoFnWithContext<InputT, OutputT> fn, DoFn.Context context) {
            super(fn);
            this.context = context;
        }

        @Override
        public PipelineOptions getPipelineOptions() {
            return this.context.getPipelineOptions();
        }

        @Override
        public void output(OutputT output) {
            this.context.output(output);
        }

        @Override
        public void outputWithTimestamp(OutputT output, Instant timestamp) {
            this.context.outputWithTimestamp(output, timestamp);
        }

        @Override
        public <T> void sideOutput(TupleTag<T> tag, T output) {
            this.context.sideOutput(tag, output);
        }

        @Override
        public <T> void sideOutputWithTimestamp(TupleTag<T> tag, T output, Instant timestamp) {
            this.context.sideOutputWithTimestamp(tag, output, timestamp);
        }

        @Override
        public BoundedWindow window() {
            throw new UnsupportedOperationException("Can only get the window in ProcessElements");
        }

        @Override
        public WindowingInternals<InputT, OutputT> windowingInternals() {
            throw new UnsupportedOperationException("Can only get the windowingInternals in ProcessElements");
        }
    }

    private static class GenericDoFnReflector
    extends DoFnReflector {
        private Method startBundle;
        private Method processElement;
        private Method finishBundle;
        private ExtraContextInfo[] processElementArgs;
        private ExtraContextInfo[] startBundleArgs;
        private ExtraContextInfo[] finishBundleArgs;

        private GenericDoFnReflector(Class<?> fn) {
            this.processElement = GenericDoFnReflector.findAnnotatedMethod(DoFnWithContext.ProcessElement.class, fn, true);
            this.startBundle = GenericDoFnReflector.findAnnotatedMethod(DoFnWithContext.StartBundle.class, fn, false);
            this.finishBundle = GenericDoFnReflector.findAnnotatedMethod(DoFnWithContext.FinishBundle.class, fn, false);
            this.processElementArgs = GenericDoFnReflector.verifyProcessMethodArguments(this.processElement);
            if (this.startBundle != null) {
                this.startBundleArgs = GenericDoFnReflector.verifyBundleMethodArguments(this.startBundle);
            }
            if (this.finishBundle != null) {
                this.finishBundleArgs = GenericDoFnReflector.verifyBundleMethodArguments(this.finishBundle);
            }
        }

        private static Collection<Method> declaredMethodsWithAnnotation(Class<? extends Annotation> anno, Class<?> startClass, Class<?> stopClass) {
            ArrayList<Method> matches = new ArrayList<Method>();
            LinkedHashSet interfaces = new LinkedHashSet();
            for (Class<?> clazz = startClass; clazz != null && !clazz.equals(stopClass); clazz = clazz.getSuperclass()) {
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(anno)) continue;
                    matches.add(method);
                }
                Collections.addAll(interfaces, clazz.getInterfaces());
            }
            for (Method method : ReflectHelpers.getClosureOfMethodsOnInterfaces(interfaces)) {
                if (!method.isAnnotationPresent(anno)) continue;
                matches.add(method);
            }
            return matches;
        }

        private static Method findAnnotatedMethod(Class<? extends Annotation> anno, Class<?> fnClazz, boolean required) {
            Collection<Method> matches = GenericDoFnReflector.declaredMethodsWithAnnotation(anno, fnClazz, DoFnWithContext.class);
            if (matches.size() == 0) {
                if (required) {
                    throw new IllegalStateException(String.format("No method annotated with @%s found in %s", anno.getSimpleName(), fnClazz.getName()));
                }
                return null;
            }
            Method first = matches.iterator().next();
            for (Method other : matches) {
                if (first.getName().equals(other.getName()) && Arrays.equals(first.getParameterTypes(), other.getParameterTypes())) continue;
                throw new IllegalStateException(String.format("Found multiple methods annotated with @%s. [%s] and [%s]", anno.getSimpleName(), DoFnReflector.format(first), DoFnReflector.format(other)));
            }
            if ((first.getModifiers() & 1) == 0) {
                throw new IllegalStateException(String.valueOf(DoFnReflector.format(first)).concat(" must be public"));
            }
            if ((first.getModifiers() & 8) != 0) {
                throw new IllegalStateException(String.valueOf(DoFnReflector.format(first)).concat(" must not be static"));
            }
            first.setAccessible(true);
            return first;
        }

        @Override
        public boolean usesSingleWindow() {
            return this.usesContext(BoundedWindow.class);
        }

        private boolean usesContext(Class<?> context) {
            for (Class<?> clazz : this.processElement.getParameterTypes()) {
                if (!clazz.equals(context)) continue;
                return true;
            }
            return false;
        }

        @Override
        <InputT, OutputT> void invokeProcessElement(DoFnWithContext<InputT, OutputT> fn, DoFnWithContext.ProcessContext c, DoFnWithContext.ExtraContextFactory<InputT, OutputT> extra) {
            this.invoke(this.processElement, fn, c, extra, this.processElementArgs);
        }

        @Override
        <InputT, OutputT> void invokeStartBundle(DoFnWithContext<InputT, OutputT> fn, DoFnWithContext.Context c, DoFnWithContext.ExtraContextFactory<InputT, OutputT> extra) {
            if (this.startBundle != null) {
                this.invoke(this.startBundle, fn, c, extra, this.startBundleArgs);
            }
        }

        @Override
        <InputT, OutputT> void invokeFinishBundle(DoFnWithContext<InputT, OutputT> fn, DoFnWithContext.Context c, DoFnWithContext.ExtraContextFactory<InputT, OutputT> extra) {
            if (this.finishBundle != null) {
                this.invoke(this.finishBundle, fn, c, extra, this.finishBundleArgs);
            }
        }

        private <InputT, OutputT> void invoke(Method m, DoFnWithContext<InputT, OutputT> on, DoFnWithContext.Context contextArg, DoFnWithContext.ExtraContextFactory<InputT, OutputT> extraArgFactory, ExtraContextInfo[] extraArgs) {
            Class<?>[] parameterTypes = m.getParameterTypes();
            Object[] args = new Object[parameterTypes.length];
            args[0] = contextArg;
            for (int i = 1; i < args.length; ++i) {
                args[i] = extraArgs[i - 1].createInstance(extraArgFactory);
            }
            try {
                m.invoke(on, args);
            }
            catch (InvocationTargetException e) {
                Throwables.propagateIfInstanceOf(e.getCause(), UserCodeException.class);
                throw new UserCodeException(e.getCause());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw Throwables.propagate(e);
            }
        }
    }

    private static interface ExtraContextInfo {
        public <InputT, OutputT> Object createInstance(DoFnWithContext.ExtraContextFactory<InputT, OutputT> var1);

        public <InputT, OutputT> TypeToken<?> tokenFor(TypeToken<InputT> var1, TypeToken<OutputT> var2);
    }
}

