/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsFactory;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Function;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.DoFnReflector;
import com.google.cloud.dataflow.sdk.transforms.DoFnWithContext;
import com.google.cloud.dataflow.sdk.util.DirectModeExecutionContext;
import com.google.cloud.dataflow.sdk.util.DirectSideInputReader;
import com.google.cloud.dataflow.sdk.util.DoFnRunner;
import com.google.cloud.dataflow.sdk.util.PTuple;
import com.google.cloud.dataflow.sdk.util.SerializableUtils;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.common.Counter;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import com.google.cloud.dataflow.sdk.values.TupleTagList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DoFnTester<InputT, OutputT> {
    final PipelineOptions options = PipelineOptionsFactory.create();
    final DoFn<InputT, OutputT> origFn;
    private Map<PCollectionView<?>, Iterable<WindowedValue<?>>> sideInputs = new HashMap();
    TupleTag<OutputT> mainOutputTag = new TupleTag();
    List<TupleTag<?>> sideOutputTags = new ArrayList();
    DoFn<InputT, OutputT> fn;
    DoFnRunner.ListOutputManager outputManager;
    DoFnRunner<InputT, OutputT> fnRunner;
    CounterSet counterSet;
    State state;

    public static <InputT, OutputT> DoFnTester<InputT, OutputT> of(DoFn<InputT, OutputT> fn) {
        return new DoFnTester<InputT, OutputT>(fn);
    }

    public static <InputT, OutputT> DoFnTester<InputT, OutputT> of(DoFnWithContext<InputT, OutputT> fn) {
        return new DoFnTester<InputT, OutputT>(DoFnReflector.of(fn.getClass()).toDoFn(fn));
    }

    public void setSideInputs(Map<PCollectionView<?>, Iterable<WindowedValue<?>>> sideInputs) {
        this.sideInputs = sideInputs;
        this.resetState();
    }

    public void setSideInput(PCollectionView<?> sideInput, Iterable<WindowedValue<?>> value) {
        this.sideInputs.put(sideInput, value);
    }

    public void setSideInputInGlobalWindow(PCollectionView<?> sideInput, Iterable<?> value) {
        this.sideInputs.put(sideInput, Iterables.transform(value, new Function<Object, WindowedValue<?>>(){

            @Override
            public WindowedValue<?> apply(Object input) {
                return WindowedValue.valueInGlobalWindow(input);
            }
        }));
    }

    public void setSideOutputTags(TupleTagList sideOutputTags) {
        this.sideOutputTags = sideOutputTags.getAll();
        this.resetState();
    }

    public List<OutputT> processBatch(InputT ... inputElements) {
        this.startBundle();
        for (InputT inputElement : inputElements) {
            this.processElement(inputElement);
        }
        this.finishBundle();
        return this.takeOutputElements();
    }

    public void startBundle() {
        this.resetState();
        this.initializeState();
        this.fnRunner.startBundle();
        this.state = State.STARTED;
    }

    public void processElement(InputT element) {
        if (this.state == State.FINISHED) {
            throw new IllegalStateException("finishBundle() has already been called");
        }
        if (this.state == State.UNSTARTED) {
            this.startBundle();
        }
        this.fnRunner.processElement(WindowedValue.valueInGlobalWindow(element));
    }

    public void finishBundle() {
        if (this.state == State.FINISHED) {
            throw new IllegalStateException("finishBundle() has already been called");
        }
        if (this.state == State.UNSTARTED) {
            this.startBundle();
        }
        this.fnRunner.finishBundle();
        this.state = State.FINISHED;
    }

    public List<OutputT> peekOutputElements() {
        return Lists.transform(this.outputManager.getOutput(this.mainOutputTag), new Function<Object, OutputT>(){

            @Override
            public OutputT apply(Object input) {
                return ((WindowedValue)input).getValue();
            }
        });
    }

    public void clearOutputElements() {
        this.peekOutputElements().clear();
    }

    public List<OutputT> takeOutputElements() {
        ArrayList<OutputT> resultElems = new ArrayList<OutputT>(this.peekOutputElements());
        this.clearOutputElements();
        return resultElems;
    }

    public <T> List<T> peekSideOutputElements(TupleTag<T> tag) {
        return Lists.transform(this.outputManager.getOutput(tag), new Function<Object, T>(){

            @Override
            public T apply(Object input) {
                return ((WindowedValue)input).getValue();
            }
        });
    }

    public <T> void clearSideOutputElements(TupleTag<T> tag) {
        this.peekSideOutputElements(tag).clear();
    }

    public <T> List<T> takeSideOutputElements(TupleTag<T> tag) {
        ArrayList<T> resultElems = new ArrayList<T>(this.peekSideOutputElements(tag));
        this.clearSideOutputElements(tag);
        return resultElems;
    }

    DoFnTester(DoFn<InputT, OutputT> origFn) {
        this.origFn = origFn;
        this.resetState();
    }

    void resetState() {
        this.fn = null;
        this.outputManager = null;
        this.fnRunner = null;
        this.counterSet = null;
        this.state = State.UNSTARTED;
    }

    void initializeState() {
        this.fn = (DoFn)SerializableUtils.deserializeFromByteArray(SerializableUtils.serializeToByteArray(this.origFn), this.origFn.toString());
        this.counterSet = new CounterSet(new Counter[0]);
        PTuple runnerSideInputs = PTuple.empty();
        for (Map.Entry<PCollectionView<?>, Iterable<WindowedValue<?>>> entry : this.sideInputs.entrySet()) {
            runnerSideInputs = runnerSideInputs.and(entry.getKey().getTagInternal(), entry.getValue());
        }
        this.outputManager = new DoFnRunner.ListOutputManager();
        this.fnRunner = DoFnRunner.create(this.options, this.fn, DirectSideInputReader.of(runnerSideInputs), this.outputManager, this.mainOutputTag, this.sideOutputTags, DirectModeExecutionContext.create().getOrCreateStepContext("stepName", "stepName", null), this.counterSet.getAddCounterMutator(), WindowingStrategy.globalDefault());
    }

    static enum State {
        UNSTARTED,
        STARTED,
        FINISHED;

    }
}

