/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.IterableCoder;
import com.google.cloud.dataflow.sdk.runners.DirectPipelineRunner;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.windowing.GlobalWindow;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PCollectionList;
import java.util.ArrayList;
import java.util.Iterator;

public class Flatten {
    public static <T> FlattenPCollectionList<T> pCollections() {
        return new FlattenPCollectionList();
    }

    public static <T> FlattenIterables<T> iterables() {
        return new FlattenIterables();
    }

    private static <T> void evaluateHelper(FlattenPCollectionList<T> transform, DirectPipelineRunner.EvaluationContext context) {
        ArrayList outputElems = new ArrayList();
        PCollectionList inputs = (PCollectionList)context.getInput(transform);
        for (PCollection input : inputs.getAll()) {
            outputElems.addAll(context.getPCollectionValuesWithMetadata(input));
        }
        context.setPCollectionValuesWithMetadata((PCollection)context.getOutput(transform), outputElems);
    }

    static {
        DirectPipelineRunner.registerDefaultTransformEvaluator(FlattenPCollectionList.class, new DirectPipelineRunner.TransformEvaluator<FlattenPCollectionList>(){

            @Override
            public void evaluate(FlattenPCollectionList transform, DirectPipelineRunner.EvaluationContext context) {
                Flatten.evaluateHelper(transform, context);
            }
        });
    }

    public static class FlattenIterables<T>
    extends PTransform<PCollection<Iterable<T>>, PCollection<T>> {
        @Override
        public PCollection<T> apply(PCollection<Iterable<T>> in) {
            Coder<Iterable<T>> inCoder = in.getCoder();
            if (!(inCoder instanceof IterableCoder)) {
                throw new IllegalArgumentException("expecting the input Coder<Iterable> to be an IterableCoder");
            }
            IterableCoder iterableCoder = (IterableCoder)inCoder;
            Coder elemCoder = iterableCoder.getElemCoder();
            return ((PCollection)in.apply(ParDo.named("FlattenIterables").of(new DoFn<Iterable<T>, T>(){

                @Override
                public void processElement(DoFn.ProcessContext c) {
                    for (Object i : (Iterable)c.element()) {
                        c.output(i);
                    }
                }
            }))).setCoder(elemCoder);
        }
    }

    public static class FlattenPCollectionList<T>
    extends PTransform<PCollectionList<T>, PCollection<T>> {
        private FlattenPCollectionList() {
        }

        @Override
        public PCollection<T> apply(PCollectionList<T> inputs) {
            WindowingStrategy<Object, GlobalWindow> windowingStrategy;
            PCollection.IsBounded isBounded = PCollection.IsBounded.BOUNDED;
            if (!inputs.getAll().isEmpty()) {
                windowingStrategy = inputs.get(0).getWindowingStrategy();
                for (PCollection<T> input : inputs.getAll()) {
                    WindowingStrategy<?, ?> other = input.getWindowingStrategy();
                    if (!windowingStrategy.getWindowFn().isCompatible(other.getWindowFn())) {
                        String string = String.valueOf(windowingStrategy.getWindowFn());
                        String string2 = String.valueOf(other.getWindowFn());
                        throw new IllegalStateException(new StringBuilder(55 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Inputs to Flatten had incompatible window windowFns: ").append(string).append(", ").append(string2).toString());
                    }
                    if (!windowingStrategy.getTrigger().getSpec().isCompatible(other.getTrigger().getSpec())) {
                        String string = String.valueOf(windowingStrategy.getTrigger());
                        String string3 = String.valueOf(other.getTrigger());
                        throw new IllegalStateException(new StringBuilder(47 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Inputs to Flatten had incompatible triggers: ").append(string).append(", ").append(string3).toString());
                    }
                    isBounded = isBounded.and(input.isBounded());
                }
            } else {
                windowingStrategy = WindowingStrategy.globalDefault();
            }
            return PCollection.createPrimitiveOutputInternal(inputs.getPipeline(), windowingStrategy, isBounded);
        }

        @Override
        protected Coder<?> getDefaultOutputCoder(PCollectionList<T> input) throws CannotProvideCoderException {
            Iterator<PCollection<T>> iterator = input.getAll().iterator();
            if (iterator.hasNext()) {
                PCollection<T> pCollection = iterator.next();
                return pCollection.getCoder();
            }
            iterator = String.valueOf(this.getClass().getSimpleName());
            String string = String.valueOf(PCollectionList.class.getSimpleName());
            throw new CannotProvideCoderException(new StringBuilder(34 + String.valueOf(iterator).length() + String.valueOf(string).length()).append((String)((Object)iterator)).append(" cannot provide a Coder for").append(" empty ").append(string).toString());
        }
    }
}

