/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.coders.BigEndianIntegerCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.coders.IterableCoder;
import com.google.cloud.dataflow.sdk.coders.KvCoder;
import com.google.cloud.dataflow.sdk.coders.VoidCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.Create;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.SerializableComparator;
import com.google.cloud.dataflow.sdk.transforms.Top;
import com.google.cloud.dataflow.sdk.transforms.View;
import com.google.cloud.dataflow.sdk.values.KV;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class Sample {
    public static <T> PTransform<PCollection<T>, PCollection<T>> any(long limit) {
        return new SampleAny(limit);
    }

    public static <T> PTransform<PCollection<T>, PCollection<Iterable<T>>> fixedSizeGlobally(int sampleSize) {
        return Combine.globally(new FixedSizedSampleFn(sampleSize));
    }

    public static <K, V> PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> fixedSizePerKey(int sampleSize) {
        return Combine.perKey(new FixedSizedSampleFn(sampleSize));
    }

    public static class FixedSizedSampleFn<T>
    extends Combine.CombineFn<T, Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>>, Iterable<T>> {
        private final Top.TopCombineFn<KV<Integer, T>, SerializableComparator<KV<Integer, T>>> topCombineFn;
        private final Random rand = new Random();

        private FixedSizedSampleFn(int sampleSize) {
            if (sampleSize < 0) {
                throw new IllegalArgumentException("sample size must be >= 0");
            }
            this.topCombineFn = new Top.TopCombineFn(sampleSize, new KV.OrderByKey());
        }

        @Override
        public Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>> createAccumulator() {
            return this.topCombineFn.createAccumulator();
        }

        @Override
        public Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>> addInput(Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>> accumulator, T input) {
            accumulator.addInput(KV.of(this.rand.nextInt(), input));
            return accumulator;
        }

        @Override
        public Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>> mergeAccumulators(Iterable<Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>>> accumulators) {
            return (Top.BoundedHeap)this.topCombineFn.mergeAccumulators(accumulators);
        }

        @Override
        public Iterable<T> extractOutput(Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>> accumulator) {
            ArrayList out = new ArrayList();
            Iterator iterator = accumulator.extractOutput().iterator();
            while (iterator.hasNext()) {
                KV element = (KV)iterator.next();
                out.add(element.getValue());
            }
            return out;
        }

        @Override
        public Coder<Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>>> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) {
            return this.topCombineFn.getAccumulatorCoder(registry, (Coder<KV<Integer, T>>)KvCoder.of(BigEndianIntegerCoder.of(), inputCoder));
        }

        @Override
        public Coder<Iterable<T>> getDefaultOutputCoder(CoderRegistry registry, Coder<T> inputCoder) {
            return IterableCoder.of(inputCoder);
        }
    }

    private static class SampleAnyDoFn<T>
    extends DoFn<Void, T> {
        long limit;
        final PCollectionView<Iterable<T>> iterableView;

        public SampleAnyDoFn(long limit, PCollectionView<Iterable<T>> iterableView) {
            this.limit = limit;
            this.iterableView = iterableView;
        }

        @Override
        public void processElement(DoFn.ProcessContext c) {
            for (T i : c.sideInput(this.iterableView)) {
                if (this.limit-- <= 0L) break;
                c.output(i);
            }
        }
    }

    public static class SampleAny<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final long limit;

        private SampleAny(long limit) {
            Preconditions.checkArgument(limit >= 0L, "Expected non-negative limit, received %s.", limit);
            this.limit = limit;
        }

        @Override
        public PCollection<T> apply(PCollection<T> in) {
            PCollectionView iterableView = (PCollectionView)in.apply(View.asIterable());
            return ((PCollection)((PCollection)in.getPipeline().apply(Create.of(new Void[]{null}).withCoder(VoidCoder.of()))).apply(ParDo.withSideInputs(iterableView).of(new SampleAnyDoFn(this.limit, iterableView)))).setCoder((Coder)in.getCoder());
        }
    }
}

