/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.coders.CustomCoder;
import com.google.cloud.dataflow.sdk.coders.ListCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObserver;
import com.google.cloud.dataflow.sdk.values.KV;
import com.google.cloud.dataflow.sdk.values.PCollection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

public class Top {
    public static <T, ComparatorT extends Comparator<T> & Serializable> Combine.Globally<T, List<T>> of(int count, ComparatorT compareFn) {
        return Combine.globally(new TopCombineFn(count, compareFn)).named("Top.Globally");
    }

    public static <T extends Comparable<T>> Combine.Globally<T, List<T>> smallest(int count) {
        return Combine.globally(new TopCombineFn(count, new Smallest())).named("Smallest.Globally");
    }

    public static <T extends Comparable<T>> Combine.Globally<T, List<T>> largest(int count) {
        return Combine.globally(new TopCombineFn(count, new Largest())).named("Largest.Globally");
    }

    public static <K, V, ComparatorT extends Comparator<V> & Serializable> PTransform<PCollection<KV<K, V>>, PCollection<KV<K, List<V>>>> perKey(int count, ComparatorT compareFn) {
        return Combine.perKey(new TopCombineFn(count, compareFn).asKeyedFn()).named("Top.PerKey");
    }

    public static <K, V extends Comparable<V>> PTransform<PCollection<KV<K, V>>, PCollection<KV<K, List<V>>>> smallestPerKey(int count) {
        return Combine.perKey(new TopCombineFn(count, new Smallest()).asKeyedFn()).named("Smallest.PerKey");
    }

    public static <K, V extends Comparable<V>> Combine.PerKey<K, V, List<V>> largestPerKey(int count) {
        return Combine.perKey(new TopCombineFn(count, new Largest()).asKeyedFn()).named("Largest.PerKey");
    }

    private static class BoundedHeapCoder<T, ComparatorT extends Comparator<T> & Serializable>
    extends CustomCoder<BoundedHeap<T, ComparatorT>> {
        private final Coder<List<T>> listCoder;
        private final ComparatorT compareFn;
        private final int maximumSize;

        public BoundedHeapCoder(int maximumSize, ComparatorT compareFn, Coder<T> elementCoder) {
            this.listCoder = ListCoder.of(elementCoder);
            this.compareFn = compareFn;
            this.maximumSize = maximumSize;
        }

        @Override
        public void encode(BoundedHeap<T, ComparatorT> value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            this.listCoder.encode(((BoundedHeap)value).asList(), outStream, context);
        }

        @Override
        public BoundedHeap<T, ComparatorT> decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            return new BoundedHeap(this.maximumSize, (Comparator)this.compareFn, this.listCoder.decode(inStream, context), null);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.verifyDeterministic("HeapCoder requires a deterministic list coder", this.listCoder);
        }

        @Override
        public boolean isRegisterByteSizeObserverCheap(BoundedHeap<T, ComparatorT> value, Coder.Context context) {
            return this.listCoder.isRegisterByteSizeObserverCheap(((BoundedHeap)value).asList(), context);
        }

        @Override
        public void registerByteSizeObserver(BoundedHeap<T, ComparatorT> value, ElementByteSizeObserver observer, Coder.Context context) throws Exception {
            this.listCoder.registerByteSizeObserver(((BoundedHeap)value).asList(), observer, context);
        }
    }

    static class BoundedHeap<T, ComparatorT extends Comparator<T> & Serializable>
    implements Combine.AccumulatingCombineFn.Accumulator<T, BoundedHeap<T, ComparatorT>, List<T>> {
        private PriorityQueue<T> asQueue;
        private List<T> asList;
        private final ComparatorT compareFn;
        private final int maximumSize;

        private BoundedHeap(int maximumSize, ComparatorT compareFn, List<T> asList) {
            this.maximumSize = maximumSize;
            this.asList = asList;
            this.compareFn = compareFn;
        }

        @Override
        public void addInput(T value) {
            this.maybeAddInput(value);
        }

        private boolean maybeAddInput(T value) {
            if (this.maximumSize == 0) {
                return false;
            }
            if (this.asQueue == null) {
                this.asQueue = new PriorityQueue(this.maximumSize, this.compareFn);
                for (T item : this.asList) {
                    this.asQueue.add(item);
                }
                this.asList = null;
            }
            if (this.asQueue.size() < this.maximumSize) {
                this.asQueue.add(value);
                return true;
            }
            if (this.compareFn.compare(value, this.asQueue.peek()) > 0) {
                this.asQueue.poll();
                this.asQueue.add(value);
                return true;
            }
            return false;
        }

        @Override
        public void mergeAccumulator(BoundedHeap<T, ComparatorT> accumulator) {
            for (T value : super.asList()) {
                if (!this.maybeAddInput(value)) break;
            }
        }

        @Override
        public List<T> extractOutput() {
            return this.asList();
        }

        private List<T> asList() {
            if (this.asList == null) {
                ArrayList<T> smallestFirstList = Lists.newArrayListWithCapacity(this.asQueue.size());
                while (!this.asQueue.isEmpty()) {
                    smallestFirstList.add(this.asQueue.poll());
                }
                this.asList = Lists.reverse(smallestFirstList);
                this.asQueue = null;
            }
            return this.asList;
        }

        /* synthetic */ BoundedHeap(int x0, Comparator x1, List x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static class TopCombineFn<T, ComparatorT extends Comparator<T> & Serializable>
    extends Combine.AccumulatingCombineFn<T, BoundedHeap<T, ComparatorT>, List<T>> {
        private final int count;
        private final ComparatorT compareFn;

        public TopCombineFn(int count, ComparatorT compareFn) {
            Preconditions.checkArgument(count >= 0, "count must be >= 0");
            this.count = count;
            this.compareFn = compareFn;
        }

        @Override
        public BoundedHeap<T, ComparatorT> createAccumulator() {
            return new BoundedHeap(this.count, (Comparator)this.compareFn, new ArrayList(), null);
        }

        @Override
        public Coder<BoundedHeap<T, ComparatorT>> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) {
            return new BoundedHeapCoder<T, ComparatorT>(this.count, this.compareFn, inputCoder);
        }
    }

    public static class Smallest<T extends Comparable<? super T>>
    implements Comparator<T>,
    Serializable {
        @Override
        public int compare(T a, T b) {
            return b.compareTo(a);
        }
    }

    public static class Largest<T extends Comparable<? super T>>
    implements Comparator<T>,
    Serializable {
        @Override
        public int compare(T a, T b) {
            return a.compareTo(b);
        }
    }
}

