/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.windowing.AfterFirst;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Repeatedly;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterEach<W extends BoundedWindow>
extends Trigger<W> {
    private AfterEach(List<Trigger<W>> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument(subTriggers.size() > 1);
    }

    @SafeVarargs
    public static <W extends BoundedWindow> Trigger<W> inOrder(Trigger<W> ... triggers) {
        return new AfterEach<W>(Arrays.asList(triggers));
    }

    private Trigger.TriggerResult result(Trigger.TriggerContext c, Trigger.TriggerResult subResult) throws Exception {
        if (subResult.isFire()) {
            return c.trigger().areAllSubtriggersFinished() ? Trigger.TriggerResult.FIRE_AND_FINISH : Trigger.TriggerResult.FIRE;
        }
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onElement(Trigger.OnElementContext c) throws Exception {
        Iterator iterator = c.trigger().unfinishedSubTriggers().iterator();
        Trigger.TriggerResult firstResult = iterator.next().invokeElement(c);
        if (c.trigger().isMerging()) {
            if (firstResult.isFire()) {
                this.resetRemaining(c, iterator);
            } else {
                while (iterator.hasNext()) {
                    iterator.next().invokeElement(c);
                }
            }
        }
        return this.result(c, firstResult);
    }

    @Override
    public Trigger.MergeResult onMerge(Trigger.OnMergeContext c) throws Exception {
        Iterator iterator = c.trigger().subTriggers().iterator();
        while (iterator.hasNext()) {
            ExecutableTrigger subTrigger = iterator.next();
            Trigger.MergeResult mergeResult = subTrigger.invokeMerge(c);
            if (Trigger.MergeResult.CONTINUE.equals((Object)mergeResult)) {
                this.resetRemaining(c, iterator);
                return Trigger.MergeResult.CONTINUE;
            }
            if (Trigger.MergeResult.FIRE.equals((Object)mergeResult)) {
                this.resetRemaining(c, iterator);
                return Trigger.MergeResult.FIRE;
            }
            if (!Trigger.MergeResult.FIRE_AND_FINISH.equals((Object)mergeResult)) continue;
            this.resetRemaining(c, iterator);
            return c.trigger().areAllSubtriggersFinished() ? Trigger.MergeResult.FIRE_AND_FINISH : Trigger.MergeResult.FIRE;
        }
        return Trigger.MergeResult.ALREADY_FINISHED;
    }

    private void resetRemaining(Trigger.TriggerContext c, Iterator<ExecutableTrigger<W>> triggers) throws Exception {
        while (triggers.hasNext()) {
            c.forTrigger(triggers.next()).trigger().resetTree();
        }
    }

    @Override
    public Trigger.TriggerResult onTimer(Trigger.OnTimerContext c) throws Exception {
        return this.result(c, c.trigger().firstUnfinishedSubTrigger().invokeTimer(c));
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        return ((Trigger)this.subTriggers.get(0)).getWatermarkThatGuaranteesFiring(window);
    }

    @Override
    public Trigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return Repeatedly.forever(new AfterFirst<W>(continuationTriggers));
    }
}

