/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.windowing.IntervalWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.PartitioningWindowFn;
import com.google.cloud.dataflow.sdk.transforms.windowing.WindowFn;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

public class FixedWindows
extends PartitioningWindowFn<Object, IntervalWindow> {
    private final Duration size;
    private final Duration offset;

    public static FixedWindows of(Duration size) {
        return new FixedWindows(size, Duration.ZERO);
    }

    public FixedWindows withOffset(Duration offset) {
        return new FixedWindows(this.size, offset);
    }

    private FixedWindows(Duration size, Duration offset) {
        if (offset.isShorterThan((ReadableDuration)Duration.ZERO) || !offset.isShorterThan((ReadableDuration)size)) {
            throw new IllegalArgumentException("FixedWindows WindowingStrategies must have 0 <= offset < size");
        }
        this.size = size;
        this.offset = offset;
    }

    @Override
    public IntervalWindow assignWindow(Instant timestamp) {
        long start = timestamp.getMillis() - timestamp.plus((ReadableDuration)this.size).minus((ReadableDuration)this.offset).getMillis() % this.size.getMillis();
        return new IntervalWindow(new Instant(start), (ReadableDuration)this.size);
    }

    @Override
    public Coder<IntervalWindow> windowCoder() {
        return IntervalWindow.getCoder();
    }

    @Override
    public boolean isCompatible(WindowFn<?, ?> other) {
        return other instanceof FixedWindows && this.size.equals((Object)((FixedWindows)other).size) && this.offset.equals((Object)((FixedWindows)other).offset);
    }

    public Duration getSize() {
        return this.size;
    }

    public Duration getOffset() {
        return this.offset;
    }
}

