/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.DurationCoder;
import com.google.cloud.dataflow.sdk.coders.InstantCoder;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class IntervalWindow
extends BoundedWindow
implements Comparable<IntervalWindow> {
    private final Instant start;
    private final Instant end;

    public IntervalWindow(Instant start, Instant end) {
        this.start = start;
        this.end = end;
    }

    public IntervalWindow(Instant start, ReadableDuration size) {
        this.start = start;
        this.end = start.plus(size);
    }

    public Instant start() {
        return this.start;
    }

    public Instant end() {
        return this.end;
    }

    @Override
    public Instant maxTimestamp() {
        return this.end.minus(1L);
    }

    public boolean contains(IntervalWindow other) {
        return !this.start.isAfter((ReadableInstant)other.start) && !this.end.isBefore((ReadableInstant)other.end);
    }

    public boolean isDisjoint(IntervalWindow other) {
        return !this.end.isAfter((ReadableInstant)other.start) || !other.end.isAfter((ReadableInstant)this.start);
    }

    public boolean intersects(IntervalWindow other) {
        return !this.isDisjoint(other);
    }

    public IntervalWindow span(IntervalWindow other) {
        return new IntervalWindow(new Instant(Math.min(this.start.getMillis(), other.start.getMillis())), new Instant(Math.max(this.end.getMillis(), other.end.getMillis())));
    }

    public boolean equals(Object o) {
        return o instanceof IntervalWindow && ((IntervalWindow)o).end.isEqual((ReadableInstant)this.end) && ((IntervalWindow)o).start.isEqual((ReadableInstant)this.start);
    }

    public int hashCode() {
        return (int)(this.start.getMillis() + (long)this.modInverse((int)(this.end.getMillis() << 1) + 1));
    }

    private int modInverse(int x) {
        int inverse = x * x * x;
        inverse *= 2 - x * inverse;
        inverse *= 2 - x * inverse;
        inverse *= 2 - x * inverse;
        return inverse;
    }

    public String toString() {
        String string = String.valueOf(this.start);
        String string2 = String.valueOf(this.end);
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length()).append("[").append(string).append("..").append(string2).append(")").toString();
    }

    @Override
    public int compareTo(IntervalWindow o) {
        if (this.start.isEqual((ReadableInstant)o.start)) {
            return this.end.compareTo((ReadableInstant)o.end);
        }
        return this.start.compareTo((ReadableInstant)o.start);
    }

    public static Coder<IntervalWindow> getCoder() {
        return IntervalWindowCoder.of();
    }

    private static class IntervalWindowCoder
    extends AtomicCoder<IntervalWindow> {
        private static final IntervalWindowCoder INSTANCE = new IntervalWindowCoder();
        private static final Coder<Instant> instantCoder = InstantCoder.of();
        private static final Coder<ReadableDuration> durationCoder = DurationCoder.of();

        private IntervalWindowCoder() {
        }

        @JsonCreator
        public static IntervalWindowCoder of() {
            return INSTANCE;
        }

        @Override
        public void encode(IntervalWindow window, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
            instantCoder.encode(window.end, outStream, context.nested());
            durationCoder.encode((ReadableDuration)new Duration((ReadableInstant)window.start, (ReadableInstant)window.end), outStream, context.nested());
        }

        @Override
        public IntervalWindow decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
            Instant end = instantCoder.decode(inStream, context.nested());
            ReadableDuration duration = durationCoder.decode(inStream, context.nested());
            return new IntervalWindow(end.minus(duration), end);
        }
    }
}

