/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import java.util.Arrays;
import java.util.List;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

class OrFinallyTrigger<W extends BoundedWindow>
extends Trigger<W> {
    private static final int ACTUAL = 0;
    private static final int UNTIL = 1;

    @VisibleForTesting
    OrFinallyTrigger(Trigger<W> actual, Trigger.OnceTrigger<W> until) {
        super(Arrays.asList(actual, until));
    }

    @Override
    public Trigger.TriggerResult onElement(Trigger.OnElementContext c) throws Exception {
        Trigger.TriggerResult untilResult = c.trigger().subTrigger(1).invokeElement(c);
        if (untilResult != Trigger.TriggerResult.CONTINUE) {
            return Trigger.TriggerResult.FIRE_AND_FINISH;
        }
        return c.trigger().subTrigger(0).invokeElement(c);
    }

    @Override
    public Trigger.MergeResult onMerge(Trigger.OnMergeContext c) throws Exception {
        Trigger.MergeResult untilResult = c.trigger().subTrigger(1).invokeMerge(c);
        if (untilResult == Trigger.MergeResult.ALREADY_FINISHED) {
            return Trigger.MergeResult.ALREADY_FINISHED;
        }
        if (untilResult.isFire()) {
            return Trigger.MergeResult.FIRE_AND_FINISH;
        }
        return c.trigger().subTrigger(0).invokeMerge(c);
    }

    @Override
    public Trigger.TriggerResult onTimer(Trigger.OnTimerContext c) throws Exception {
        Trigger.TriggerResult untilResult = c.trigger().subTrigger(1).invokeTimer(c);
        if (untilResult != Trigger.TriggerResult.CONTINUE) {
            return Trigger.TriggerResult.FIRE_AND_FINISH;
        }
        return c.trigger().subTrigger(0).invokeTimer(c);
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        Instant untilDeadline;
        Instant actualDeadline = ((Trigger)this.subTriggers.get(0)).getWatermarkThatGuaranteesFiring(window);
        return actualDeadline.isBefore((ReadableInstant)(untilDeadline = ((Trigger)this.subTriggers.get(1)).getWatermarkThatGuaranteesFiring(window))) ? actualDeadline : untilDeadline;
    }

    @Override
    public Trigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return new OrFinallyTrigger<W>(continuationTriggers.get(0), (Trigger.OnceTrigger)continuationTriggers.get(1));
    }
}

