/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.runners.DirectPipelineRunner;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.DefaultTrigger;
import com.google.cloud.dataflow.sdk.transforms.windowing.InvalidWindows;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.transforms.windowing.TriggerBuilder;
import com.google.cloud.dataflow.sdk.transforms.windowing.WindowFn;
import com.google.cloud.dataflow.sdk.util.AssignWindowsDoFn;
import com.google.cloud.dataflow.sdk.util.DirectModeExecutionContext;
import com.google.cloud.dataflow.sdk.util.DoFnRunner;
import com.google.cloud.dataflow.sdk.util.NullSideInputReader;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.joda.time.Duration;

public class Window {
    public static Unbound named(String name) {
        return new Unbound().named(name);
    }

    public static <T> Bound<T> into(WindowFn<? super T, ?> fn) {
        return new Unbound().into(fn);
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public static <T> Bound<T> triggering(TriggerBuilder<?> trigger) {
        return new Unbound().triggering(trigger);
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public static <T> Bound<T> discardingFiredPanes() {
        return new Unbound().discardingFiredPanes();
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public static <T> Bound<T> accumulatingFiredPanes() {
        return new Unbound().accumulatingFiredPanes();
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public static <T> Bound<T> withAllowedLateness(Duration allowedLateness) {
        return new Unbound().withAllowedLateness(allowedLateness);
    }

    private static <T> PTransform<PCollection<? extends T>, PCollection<T>> identity() {
        return ParDo.named("Identity").of(new DoFn<T, T>(){

            @Override
            public void processElement(DoFn.ProcessContext c) {
                c.output(c.element());
            }
        });
    }

    public static <T> Remerge<T> remerge() {
        return new Remerge();
    }

    private static <T, W extends BoundedWindow> void evaluateHelper(Bound<T> transform, DirectPipelineRunner.EvaluationContext context) {
        if (((Bound)transform).windowFn == null) {
            throw new IllegalStateException("Shouldn't reach evaluateHelper with no windowFn");
        }
        PCollection input = (PCollection)context.getInput(transform);
        DirectModeExecutionContext executionContext = DirectModeExecutionContext.create();
        TupleTag outputTag = new TupleTag();
        WindowFn windowFn = ((Bound)transform).windowFn;
        String name = context.getStepName(transform);
        AssignWindowsDoFn addWindowsDoFn = new AssignWindowsDoFn(windowFn);
        DoFnRunner addWindowsRunner = DoFnRunner.create(context.getPipelineOptions(), addWindowsDoFn, NullSideInputReader.empty(), new DoFnRunner.ListOutputManager(), outputTag, new ArrayList(), executionContext.getOrCreateStepContext(name, name, null), context.getAddCounterMutator(), ((PCollection)context.getOutput(transform)).getWindowingStrategy());
        addWindowsRunner.startBundle();
        for (DirectPipelineRunner.ValueWithMetadata inputElem : context.getPCollectionValuesWithMetadata(input)) {
            executionContext.setKey(inputElem.getKey());
            addWindowsRunner.processElement(inputElem.getWindowedValue());
        }
        addWindowsRunner.finishBundle();
        context.setPCollectionValuesWithMetadata((PCollection)context.getOutput(transform), executionContext.getOutput(outputTag));
    }

    static {
        DirectPipelineRunner.registerDefaultTransformEvaluator(Bound.class, new DirectPipelineRunner.TransformEvaluator<Bound>(){

            @Override
            public void evaluate(Bound transform, DirectPipelineRunner.EvaluationContext context) {
                Window.evaluateHelper(transform, context);
            }
        });
    }

    public static class Remerge<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        @Override
        public PCollection<T> apply(PCollection<T> input) {
            WindowingStrategy<?, ?> outputWindowingStrategy = this.getOutputWindowing(input.getWindowingStrategy());
            return ((PCollection)input.apply(Window.identity())).setWindowingStrategyInternal(outputWindowingStrategy);
        }

        private <W extends BoundedWindow> WindowingStrategy<?, W> getOutputWindowing(WindowingStrategy<?, W> inputStrategy) {
            if (inputStrategy.getWindowFn() instanceof InvalidWindows) {
                InvalidWindows invalidWindows = (InvalidWindows)inputStrategy.getWindowFn();
                return inputStrategy.withWindowFn(invalidWindows.getOriginalWindowFn());
            }
            return inputStrategy;
        }
    }

    public static class Bound<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        @Nullable
        private final WindowFn<? super T, ?> windowFn;
        @Nullable
        private final Trigger<?> trigger;
        @Nullable
        private final WindowingStrategy.AccumulationMode mode;
        @Nullable
        private final Duration allowedLateness;
        @Nullable
        private final ClosingBehavior closingBehavior;

        private Bound(String name, @Nullable WindowFn<? super T, ?> windowFn, @Nullable Trigger<?> trigger, @Nullable WindowingStrategy.AccumulationMode mode, @Nullable Duration allowedLateness, ClosingBehavior behavior) {
            super(name);
            this.windowFn = windowFn;
            this.trigger = trigger;
            this.mode = mode;
            this.allowedLateness = allowedLateness;
            this.closingBehavior = behavior;
        }

        private Bound(String name) {
            this(name, null, null, null, null, null);
        }

        private Bound<T> into(WindowFn<? super T, ?> windowFn) {
            try {
                windowFn.windowCoder().verifyDeterministic();
            }
            catch (Coder.NonDeterministicException e) {
                throw new IllegalArgumentException("Window coders must be deterministic.", e);
            }
            return new Bound<T>(this.name, windowFn, this.trigger, this.mode, this.allowedLateness, this.closingBehavior);
        }

        public Bound<T> named(String name) {
            return new Bound<T>(name, this.windowFn, this.trigger, this.mode, this.allowedLateness, this.closingBehavior);
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public Bound<T> triggering(TriggerBuilder<?> trigger) {
            return new Bound<T>(this.name, this.windowFn, trigger.buildTrigger(), this.mode, this.allowedLateness, this.closingBehavior);
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public Bound<T> discardingFiredPanes() {
            return new Bound<T>(this.name, this.windowFn, this.trigger, WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, this.allowedLateness, this.closingBehavior);
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public Bound<T> accumulatingFiredPanes() {
            return new Bound<T>(this.name, this.windowFn, this.trigger, WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES, this.allowedLateness, this.closingBehavior);
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public Bound<T> withAllowedLateness(Duration allowedLateness) {
            return new Bound<T>(this.name, this.windowFn, this.trigger, this.mode, allowedLateness, this.closingBehavior);
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public Bound<T> withAllowedLateness(Duration allowedLateness, ClosingBehavior behavior) {
            return new Bound<T>(this.name, this.windowFn, this.trigger, this.mode, allowedLateness, behavior);
        }

        private WindowingStrategy<?, ?> getOutputStrategy(WindowingStrategy<?, ?> inputStrategy) {
            WindowingStrategy<Object, Object> result = inputStrategy;
            if (this.windowFn != null) {
                result = result.withWindowFn(this.windowFn);
            }
            if (this.trigger != null) {
                result = result.withTrigger(this.trigger);
            }
            if (this.mode != null) {
                result = result.withMode(this.mode);
            }
            if (this.allowedLateness != null) {
                result = result.withAllowedLateness(this.allowedLateness);
            }
            if (this.closingBehavior != null) {
                result = result.withClosingBehavior(this.closingBehavior);
            }
            return result;
        }

        @Override
        public void validate(PCollection<T> input) {
            WindowingStrategy<?, ?> outputStrategy = this.getOutputStrategy(input.getWindowingStrategy());
            if (outputStrategy.isTriggerSpecified() && !(outputStrategy.getTrigger().getSpec() instanceof DefaultTrigger)) {
                if (!outputStrategy.isAllowedLatenessSpecified()) {
                    throw new IllegalArgumentException("Calling .triggering() to specify a trigger requires that the allowed lateness be specified using .withAllowedLateness() to set the upper bound on how late data can arrive before being dropped. See Javadoc for more details.");
                }
                if (!outputStrategy.isModeSpecified()) {
                    throw new IllegalArgumentException("Calling .triggering() to specify a trigger requires that the accumulation mode be specified using .discardingFiredPanes() or .accumulatingFiredPanes(). See Javadoc for more details.");
                }
            }
        }

        @Override
        public PCollection<T> apply(PCollection<T> input) {
            WindowingStrategy<?, ?> outputStrategy = this.getOutputStrategy(input.getWindowingStrategy());
            if (this.windowFn != null) {
                return PCollection.createPrimitiveOutputInternal(input.getPipeline(), outputStrategy, input.isBounded());
            }
            return ((PCollection)input.apply(Window.identity())).setWindowingStrategyInternal(outputStrategy);
        }

        @Override
        protected Coder<?> getDefaultOutputCoder(PCollection<T> input) {
            return input.getCoder();
        }

        @Override
        protected String getKindString() {
            return "Window.Into()";
        }
    }

    public static class Unbound {
        String name;

        Unbound() {
        }

        Unbound(String name) {
            this.name = name;
        }

        public Unbound named(String name) {
            return new Unbound(name);
        }

        public <T> Bound<T> into(WindowFn<? super T, ?> fn) {
            return new Bound(this.name).into(fn);
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public <T> Bound<T> triggering(TriggerBuilder<?> trigger) {
            return new Bound(this.name).triggering(trigger);
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public <T> Bound<T> discardingFiredPanes() {
            return new Bound(this.name).discardingFiredPanes();
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public <T> Bound<T> accumulatingFiredPanes() {
            return new Bound(this.name).accumulatingFiredPanes();
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public <T> Bound<T> withAllowedLateness(Duration allowedLateness) {
            return new Bound(this.name).withAllowedLateness(allowedLateness);
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public <T> Bound<T> withAllowedLateness(Duration allowedLateness, ClosingBehavior behavior) {
            return new Bound(this.name).withAllowedLateness(allowedLateness, behavior);
        }
    }

    public static enum ClosingBehavior {
        FIRE_ALWAYS,
        FIRE_IF_NON_EMPTY;

    }
}

