/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Joiner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Supplier;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Maps;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Multimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Multimaps;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Sets;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.reflect.ClassPath;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.reflect.Invokable;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.reflect.Parameter;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class ApiSurface {
    private final Set<Class<?>> rootClasses;
    private final Set<Pattern> patternsToPrune;
    private Multimap<Class<?>, Class<?>> exposedToExposers = null;
    private Pattern prunedPattern = null;
    private Set<Type> visited = null;

    public static ApiSurface empty() {
        return new ApiSurface(Collections.emptySet(), Collections.emptySet());
    }

    public static ApiSurface ofPackage(String packageName) throws IOException {
        return ApiSurface.empty().includingPackage(packageName);
    }

    public static ApiSurface ofClass(Class<?> clazz) {
        return ApiSurface.empty().includingClass(clazz);
    }

    public ApiSurface includingPackage(String packageName) throws IOException {
        ClassPath classPath = ClassPath.from(ClassLoader.getSystemClassLoader());
        HashSet<Class<?>> newRootClasses = Sets.newHashSet();
        newRootClasses.addAll(this.rootClasses);
        for (ClassPath.ClassInfo classInfo : classPath.getTopLevelClassesRecursive(packageName)) {
            Class<?> clazz = classInfo.load();
            if (!this.exposed(clazz.getModifiers())) continue;
            newRootClasses.add(clazz);
        }
        return new ApiSurface(newRootClasses, this.patternsToPrune);
    }

    public ApiSurface includingClass(Class<?> clazz) {
        HashSet<Class<?>> newRootClasses = Sets.newHashSet();
        newRootClasses.addAll(this.rootClasses);
        newRootClasses.add(clazz);
        return new ApiSurface(newRootClasses, this.patternsToPrune);
    }

    public ApiSurface pruningPrefix(String prefix) {
        return this.pruningPattern(Pattern.compile(String.valueOf(Pattern.quote(prefix)).concat(".*")));
    }

    public ApiSurface pruningClassName(String className) {
        return this.pruningPattern(Pattern.compile(Pattern.quote(className)));
    }

    public ApiSurface pruningClass(Class<?> clazz) {
        return this.pruningClassName(clazz.getName());
    }

    public ApiSurface pruningPattern(Pattern pattern) {
        HashSet<Pattern> newPatterns = Sets.newHashSet();
        newPatterns.addAll(this.patternsToPrune);
        newPatterns.add(pattern);
        return new ApiSurface(this.rootClasses, newPatterns);
    }

    public ApiSurface pruningPattern(String patternString) {
        return this.pruningPattern(Pattern.compile(patternString));
    }

    public Set<Class<?>> getRootClasses() {
        return this.rootClasses;
    }

    public Set<Class<?>> getExposedClasses() {
        return this.getExposedToExposers().keySet();
    }

    public List<Class<?>> getAnyExposurePath(Class<?> exposedClass) {
        HashSet<Class<?>> excluded = Sets.newHashSet();
        excluded.add(exposedClass);
        List<Class<?>> path = this.getAnyExposurePath(exposedClass, excluded);
        if (path == null) {
            String string = String.valueOf(exposedClass);
            throw new IllegalArgumentException(new StringBuilder(88 + String.valueOf(string).length()).append("Class ").append(string).append(" has no path back to any root class.").append(" It should never have been considered exposed.").toString());
        }
        return path;
    }

    private List<Class<?>> getAnyExposurePath(Class<?> exposedClass, Set<Class<?>> excluded) {
        ArrayList<Class<?>> exposurePath = Lists.newArrayList();
        exposurePath.add(exposedClass);
        Collection<Class<?>> exposers = this.getExposedToExposers().get(exposedClass);
        if (exposers.isEmpty()) {
            String string = String.valueOf(exposedClass);
            throw new IllegalArgumentException(new StringBuilder(22 + String.valueOf(string).length()).append("Class ").append(string).append(" is not exposed.").toString());
        }
        for (Class<?> exposer : exposers) {
            if (excluded.contains(exposer)) continue;
            if (exposer == null) {
                return exposurePath;
            }
            List<Class<?>> restOfPath = this.getAnyExposurePath(exposer, Sets.union(excluded, Sets.newHashSet(exposer)));
            if (restOfPath == null) continue;
            exposurePath.addAll(restOfPath);
            return exposurePath;
        }
        return null;
    }

    private ApiSurface(Set<Class<?>> rootClasses, Set<Pattern> patternsToPrune) {
        this.rootClasses = rootClasses;
        this.patternsToPrune = patternsToPrune;
    }

    private Multimap<Class<?>, Class<?>> getExposedToExposers() {
        if (this.exposedToExposers == null) {
            this.constructExposedToExposers();
        }
        return this.exposedToExposers;
    }

    private void constructExposedToExposers() {
        this.visited = Sets.newHashSet();
        this.exposedToExposers = Multimaps.newSetMultimap(Maps.newHashMap(), new Supplier<Set<Class<?>>>(){

            @Override
            public Set<Class<?>> get() {
                return Sets.newHashSet();
            }
        });
        for (Class<?> clazz : this.rootClasses) {
            this.addExposedTypes(clazz, null);
        }
    }

    private Pattern getPrunedPattern() {
        if (this.prunedPattern == null) {
            this.constructPrunedPattern();
        }
        return this.prunedPattern;
    }

    private void constructPrunedPattern() {
        HashSet<String> prunedPatternStrings = Sets.newHashSet();
        for (Pattern patternToPrune : this.patternsToPrune) {
            prunedPatternStrings.add(patternToPrune.pattern());
        }
        String string = String.valueOf(Joiner.on(")|(").join(prunedPatternStrings));
        this.prunedPattern = Pattern.compile(new StringBuilder(2 + String.valueOf(string).length()).append("(").append(string).append(")").toString());
    }

    private boolean pruned(Type type) {
        return this.pruned(TypeToken.of(type).getRawType());
    }

    private boolean pruned(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.isArray() || this.getPrunedPattern().matcher(clazz.getName()).matches();
    }

    private boolean done(Type type) {
        return this.visited.contains(type);
    }

    private void recordExposure(Class<?> exposed, Class<?> cause) {
        this.exposedToExposers.put(exposed, cause);
    }

    private void recordExposure(Type exposed, Class<?> cause) {
        this.exposedToExposers.put(TypeToken.of(exposed).getRawType(), cause);
    }

    private void visit(Type type) {
        this.visited.add(type);
    }

    private void addExposedTypes(TypeToken type, Class<?> cause) {
        this.addExposedTypes(type.getType(), cause);
    }

    private void addExposedTypes(Type type, Class<?> cause) {
        if (type instanceof TypeVariable) {
            this.addExposedTypes((TypeVariable)type, cause);
        } else if (type instanceof WildcardType) {
            this.addExposedTypes((WildcardType)type, cause);
        } else if (type instanceof GenericArrayType) {
            this.addExposedTypes((GenericArrayType)type, cause);
        } else if (type instanceof ParameterizedType) {
            this.addExposedTypes((ParameterizedType)type, cause);
        } else if (type instanceof Class) {
            this.addExposedTypes((Class)type, cause);
        } else {
            throw new IllegalArgumentException("Unknown implementation of Type");
        }
    }

    private void addExposedTypes(TypeVariable type, Class<?> cause) {
        if (this.done(type)) {
            return;
        }
        this.visit(type);
        for (Type bound : type.getBounds()) {
            this.addExposedTypes(bound, cause);
        }
    }

    private void addExposedTypes(WildcardType type, Class<?> cause) {
        this.visit(type);
        for (Type lowerBound : type.getLowerBounds()) {
            this.addExposedTypes(lowerBound, cause);
        }
        for (Type upperBound : type.getUpperBounds()) {
            this.addExposedTypes(upperBound, cause);
        }
    }

    private void addExposedTypes(GenericArrayType type, Class<?> cause) {
        if (this.done(type)) {
            return;
        }
        this.visit(type);
        this.addExposedTypes(type.getGenericComponentType(), cause);
    }

    private void addExposedTypes(ParameterizedType type, Class<?> cause) {
        boolean alreadyDone = this.done(type);
        if (!this.pruned(type)) {
            this.visit(type);
            this.recordExposure(type, cause);
        }
        if (alreadyDone) {
            return;
        }
        this.addExposedTypes(type.getRawType(), cause);
        for (Type typeArg : type.getActualTypeArguments()) {
            this.addExposedTypes(typeArg, cause);
        }
    }

    private void addExposedTypes(Class<?> clazz, Class<?> cause) {
        if (this.pruned(clazz)) {
            return;
        }
        boolean alreadyDone = this.done(clazz);
        this.visit(clazz);
        this.recordExposure(clazz, cause);
        if (alreadyDone || this.pruned(clazz)) {
            return;
        }
        TypeToken<?> token = TypeToken.of(clazz);
        for (TypeToken superType : token.getTypes()) {
            if (superType.equals(token)) continue;
            this.addExposedTypes(superType, clazz);
        }
        for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
            if (!this.exposed(clazz2.getModifiers())) continue;
            this.addExposedTypes(clazz2, clazz);
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
            if (!this.exposed(((Field)annotatedElement).getModifiers())) continue;
            this.addExposedTypes((Field)annotatedElement, clazz);
        }
        for (Invokable invokable : this.getExposedInvokables(token)) {
            this.addExposedTypes(invokable, clazz);
        }
    }

    private void addExposedTypes(Invokable<?, ?> invokable, Class<?> cause) {
        this.addExposedTypes(invokable.getReturnType(), cause);
        for (Annotation annotation : invokable.getAnnotations()) {
            this.addExposedTypes(annotation.annotationType(), cause);
        }
        for (Parameter parameter : invokable.getParameters()) {
            this.addExposedTypes(parameter, cause);
        }
        for (TypeToken typeToken : invokable.getExceptionTypes()) {
            this.addExposedTypes(typeToken, cause);
        }
    }

    private void addExposedTypes(Parameter parameter, Class<?> cause) {
        this.addExposedTypes(parameter.getType(), cause);
        for (Annotation annotation : parameter.getAnnotations()) {
            this.addExposedTypes(annotation.annotationType(), cause);
        }
    }

    private void addExposedTypes(Field field, Class<?> cause) {
        this.addExposedTypes(field.getGenericType(), cause);
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            this.addExposedTypes(annotation.annotationType(), cause);
        }
    }

    private Set<Invokable> getExposedInvokables(TypeToken type) {
        HashSet<Invokable> invokables = Sets.newHashSet();
        for (Constructor<?> constructor : type.getRawType().getConstructors()) {
            if (0 == (constructor.getModifiers() & 5)) continue;
            invokables.add(type.constructor(constructor));
        }
        for (Executable executable : type.getRawType().getMethods()) {
            if (0 == (((Method)executable).getModifiers() & 5)) continue;
            invokables.add(type.method((Method)executable));
        }
        return invokables;
    }

    private boolean exposed(int modifiers) {
        return 0 != (modifiers & 5);
    }

    public static ApiSurface getSdkApiSurface() throws IOException {
        return ApiSurface.ofPackage("com.google.cloud.dataflow").pruningPattern("com[.]google[.]cloud[.]dataflow.*Test").pruningPrefix("java").pruningPrefix("com.google.api").pruningPrefix("com.google.protobuf").pruningPrefix("org.joda.time").pruningPrefix("org.apache.avro").pruningPrefix("org.junit").pruningPrefix("com.fasterxml.jackson.annotation");
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> names = Lists.newArrayList();
        for (Class<?> clazz : ApiSurface.getSdkApiSurface().getExposedClasses()) {
            names.add(clazz.getName());
        }
        ArrayList<String> sortedNames = Lists.newArrayList(names);
        Collections.sort(sortedNames);
        for (String name : sortedNames) {
            System.out.println(name);
        }
    }
}

