/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.coders.KvCoder;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.util.SerializableUtils;
import java.io.Serializable;

public class AppliedCombineFn<K, InputT, AccumT, OutputT>
implements Serializable {
    private final Combine.KeyedCombineFn<K, InputT, AccumT, OutputT> fn;
    private final Coder<AccumT> accumulatorCoder;

    private AppliedCombineFn(Combine.KeyedCombineFn<K, InputT, AccumT, OutputT> fn, Coder<AccumT> accumulatorCoder) {
        this.fn = fn;
        this.accumulatorCoder = accumulatorCoder;
    }

    public static <K, InputT, AccumT, OutputT> AppliedCombineFn<K, InputT, AccumT, OutputT> withAccumulatorCoder(Combine.KeyedCombineFn<? super K, ? super InputT, AccumT, OutputT> fn, Coder<AccumT> accumCoder) {
        Combine.KeyedCombineFn<? super K, ? super InputT, AccumT, OutputT> clonedFn = SerializableUtils.clone(fn);
        return new AppliedCombineFn<K, InputT, AccumT, OutputT>(clonedFn, accumCoder);
    }

    public static <K, InputT, AccumT, OutputT> AppliedCombineFn<K, InputT, AccumT, OutputT> withInputCoder(Combine.KeyedCombineFn<? super K, ? super InputT, AccumT, OutputT> fn, CoderRegistry registry, KvCoder<K, InputT> kvCoder) {
        Combine.KeyedCombineFn<K, InputT, AccumT, OutputT> clonedFn = SerializableUtils.clone(fn);
        try {
            Coder<AccumT> accumulatorCoder = clonedFn.getAccumulatorCoder(registry, kvCoder.getKeyCoder(), kvCoder.getValueCoder());
            return new AppliedCombineFn<K, InputT, AccumT, OutputT>(clonedFn, accumulatorCoder);
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalStateException("Could not determine coder for accumulator", e);
        }
    }

    public Combine.KeyedCombineFn<K, InputT, AccumT, OutputT> getFn() {
        return this.fn;
    }

    public Coder<AccumT> getAccumulatorCoder() {
        return this.accumulatorCoder;
    }
}

