/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.client.util.NanoClock;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.util.AttemptBoundedExponentialBackOff;
import java.util.concurrent.TimeUnit;

public class AttemptAndTimeBoundedExponentialBackOff
extends AttemptBoundedExponentialBackOff {
    private long endTimeMillis;
    private long maximumTotalWaitTimeMillis;
    private ResetPolicy resetPolicy;
    private final NanoClock nanoClock;
    private static final long MAX_ELAPSED_TIME_MILLIS = 0x20000000000000L;

    public AttemptAndTimeBoundedExponentialBackOff(int maximumNumberOfAttempts, long initialIntervalMillis, long maximumTotalWaitTimeMillis) {
        this(maximumNumberOfAttempts, initialIntervalMillis, maximumTotalWaitTimeMillis, ResetPolicy.ALL, NanoClock.SYSTEM);
    }

    public AttemptAndTimeBoundedExponentialBackOff(int maximumNumberOfAttempts, long initialIntervalMillis, long maximumTotalWaitTimeMillis, ResetPolicy resetPolicy) {
        this(maximumNumberOfAttempts, initialIntervalMillis, maximumTotalWaitTimeMillis, resetPolicy, NanoClock.SYSTEM);
    }

    public AttemptAndTimeBoundedExponentialBackOff(int maximumNumberOfAttempts, long initialIntervalMillis, long maximumTotalWaitTimeMillis, ResetPolicy resetPolicy, NanoClock nanoClock) {
        super(maximumNumberOfAttempts, initialIntervalMillis);
        Preconditions.checkArgument(maximumTotalWaitTimeMillis > 0L, "Maximum total wait time must be greater than zero.");
        Preconditions.checkArgument(maximumTotalWaitTimeMillis < 0x20000000000000L, "Maximum total wait time must be less than 9007199254740992 milliseconds");
        Preconditions.checkArgument(resetPolicy != null, "resetPolicy may not be null");
        Preconditions.checkArgument(nanoClock != null, "nanoClock may not be null");
        this.maximumTotalWaitTimeMillis = maximumTotalWaitTimeMillis;
        this.resetPolicy = resetPolicy;
        this.nanoClock = nanoClock;
        this.endTimeMillis = this.getTimeMillis() + maximumTotalWaitTimeMillis;
    }

    @Override
    public void reset() {
        if (this.resetPolicy == null) {
            super.reset();
            return;
        }
        if (this.resetPolicy == ResetPolicy.ALL || this.resetPolicy == ResetPolicy.ATTEMPTS) {
            super.reset();
        }
        if (this.resetPolicy == ResetPolicy.ALL || this.resetPolicy == ResetPolicy.TIMER) {
            this.endTimeMillis = this.getTimeMillis() + this.maximumTotalWaitTimeMillis;
        }
    }

    public void setEndtimeMillis(long endTimeMillis) {
        this.endTimeMillis = endTimeMillis;
    }

    @Override
    public long nextBackOffMillis() {
        if (this.atMaxAttempts()) {
            return -1L;
        }
        long backoff = Math.min(super.nextBackOffMillis(), this.endTimeMillis - this.getTimeMillis());
        return backoff > 0L ? backoff : -1L;
    }

    private long getTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.nanoClock.nanoTime());
    }

    @Override
    public boolean atMaxAttempts() {
        return super.atMaxAttempts() || this.getTimeMillis() >= this.endTimeMillis;
    }

    public static enum ResetPolicy {
        ALL,
        ATTEMPTS,
        TIMER;

    }
}

