/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.dataflow.sdk.io.BigQueryIO;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Throwables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.cloud.dataflow.sdk.util.AttemptBoundedExponentialBackOff;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryTableInserter {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryTableInserter.class);
    private static final long UPLOAD_BATCH_SIZE_BYTES = 65536L;
    private static final long MAX_ROWS_PER_BATCH = 500L;
    private static final int MAX_INSERT_ATTEMPTS = 5;
    private static final long INITIAL_INSERT_BACKOFF_INTERVAL_MS = 200L;
    private final Bigquery client;
    private final TableReference defaultRef;
    private final long maxRowsPerBatch;
    private static final ExecutorService executor = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)Executors.newFixedThreadPool(100), 10L, TimeUnit.SECONDS);

    public BigQueryTableInserter(Bigquery client) {
        this.client = client;
        this.defaultRef = null;
        this.maxRowsPerBatch = 500L;
    }

    @Deprecated
    public BigQueryTableInserter(Bigquery client, TableReference defaultRef) {
        this.client = client;
        this.defaultRef = defaultRef;
        this.maxRowsPerBatch = 500L;
    }

    public BigQueryTableInserter(Bigquery client, int maxRowsPerBatch) {
        this.client = client;
        this.defaultRef = null;
        this.maxRowsPerBatch = maxRowsPerBatch;
    }

    @Deprecated
    public BigQueryTableInserter(Bigquery client, TableReference defaultRef, int maxRowsPerBatch) {
        this.client = client;
        this.defaultRef = defaultRef;
        this.maxRowsPerBatch = maxRowsPerBatch;
    }

    @Deprecated
    public void insertAll(List<TableRow> rowList) throws IOException {
        this.insertAll(this.defaultRef, rowList, null);
    }

    @Deprecated
    public void insertAll(List<TableRow> rowList, @Nullable List<String> insertIdList) throws IOException {
        this.insertAll(this.defaultRef, rowList, insertIdList);
    }

    public void insertAll(TableReference ref, List<TableRow> rowList) throws IOException {
        this.insertAll(ref, rowList, null);
    }

    public void insertAll(TableReference ref, List<TableRow> rowList, @Nullable List<String> insertIdList) throws IOException {
        Preconditions.checkNotNull(ref, "ref");
        if (insertIdList != null && rowList.size() != insertIdList.size()) {
            throw new AssertionError((Object)"If insertIdList is not null it needs to have at least as many elements as rowList");
        }
        AttemptBoundedExponentialBackOff backoff = new AttemptBoundedExponentialBackOff(5, 200L);
        final ArrayList allErrors = new ArrayList();
        List<TableRow> rowsToPublish = rowList;
        List<String> idsToPublish = insertIdList;
        while (true) {
            final ArrayList<TableRow> retryRows = new ArrayList<TableRow>();
            final ArrayList<String> retryIds = idsToPublish != null ? new ArrayList<String>() : null;
            int strideIndex = 0;
            LinkedList<TableDataInsertAllRequest.Rows> rows = new LinkedList<TableDataInsertAllRequest.Rows>();
            int dataSize = 0;
            ArrayList futures = new ArrayList();
            for (int i = 0; i < rowsToPublish.size(); ++i) {
                TableRow tableRow = rowsToPublish.get(i);
                TableDataInsertAllRequest.Rows out = new TableDataInsertAllRequest.Rows();
                if (idsToPublish != null) {
                    out.setInsertId(idsToPublish.get(i));
                }
                out.setJson(tableRow.getUnknownKeys());
                rows.add(out);
                if ((long)(dataSize += tableRow.toString().length()) < 65536L && (long)rows.size() < this.maxRowsPerBatch && i != rowsToPublish.size() - 1) continue;
                TableDataInsertAllRequest content = new TableDataInsertAllRequest();
                content.setRows(rows);
                final Bigquery.Tabledata.InsertAll insert = this.client.tabledata().insertAll(ref.getProjectId(), ref.getDatasetId(), ref.getTableId(), content);
                final int finalStrideIndex = strideIndex;
                final List<TableRow> finalRowsToPublish = rowsToPublish;
                final List<String> finalIdsToPublish = idsToPublish;
                futures.add(executor.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block7: {
                            try {
                                TableDataInsertAllResponse response = (TableDataInsertAllResponse)insert.execute();
                                List errors = response.getInsertErrors();
                                if (errors == null) break block7;
                                1 var3_4 = this;
                                synchronized (var3_4) {
                                    allErrors.addAll(errors);
                                    for (TableDataInsertAllResponse.InsertErrors error : errors) {
                                        if (error.getIndex() == null) {
                                            String string = String.valueOf(allErrors);
                                            throw new IOException(new StringBuilder(15 + String.valueOf(string).length()).append("Insert failed: ").append(string).toString());
                                        }
                                        int errorIndex = error.getIndex().intValue() + finalStrideIndex;
                                        retryRows.add(finalRowsToPublish.get(errorIndex));
                                        if (retryIds == null) continue;
                                        retryIds.add(finalIdsToPublish.get(errorIndex));
                                    }
                                }
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                }));
                dataSize = 0;
                strideIndex = i + 1;
                rows = new LinkedList();
            }
            try {
                for (Future future : futures) {
                    future.get();
                }
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                Throwables.propagate(e.getCause());
            }
            if (allErrors.isEmpty() || backoff.atMaxAttempts()) break;
            try {
                Thread.sleep(backoff.nextBackOffMillis());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            LOG.info("Retrying failed inserts to BigQuery");
            rowsToPublish = retryRows;
            idsToPublish = retryIds;
            allErrors.clear();
        }
        if (!allErrors.isEmpty()) {
            String string = String.valueOf(allErrors);
            throw new IOException(new StringBuilder(15 + String.valueOf(string).length()).append("Insert failed: ").append(string).toString());
        }
    }

    public Table getOrCreateTable(TableReference ref, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, @Nullable TableSchema schema) throws IOException {
        Table table;
        block9: {
            Bigquery.Tables.Get get = this.client.tables().get(ref.getProjectId(), ref.getDatasetId(), ref.getTableId());
            table = null;
            try {
                table = (Table)get.execute();
            }
            catch (IOException e) {
                ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
                if (errorExtractor.itemNotFound(e) && createDisposition == BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED) break block9;
                throw e;
            }
        }
        if (table != null) {
            if (writeDisposition == BigQueryIO.Write.WriteDisposition.WRITE_APPEND) {
                return table;
            }
            boolean empty = this.isEmpty(ref);
            if (empty) {
                if (writeDisposition == BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE) {
                    LOG.info("Empty table found, not removing {}", (Object)BigQueryIO.toTableSpec(ref));
                }
                return table;
            }
            if (writeDisposition == BigQueryIO.Write.WriteDisposition.WRITE_EMPTY) {
                throw new IOException("WriteDisposition is WRITE_EMPTY, but table is not empty");
            }
            if (schema == null) {
                schema = table.getSchema();
            }
            LOG.info("Deleting table {}", (Object)BigQueryIO.toTableSpec(ref));
            Bigquery.Tables.Delete delete = this.client.tables().delete(ref.getProjectId(), ref.getDatasetId(), ref.getTableId());
            delete.execute();
        }
        if (schema == null) {
            throw new IllegalArgumentException("Table schema required for new table.");
        }
        return this.tryCreateTable(ref, schema);
    }

    public boolean isEmpty(TableReference ref) throws IOException {
        Bigquery.Tabledata.List list = this.client.tabledata().list(ref.getProjectId(), ref.getDatasetId(), ref.getTableId());
        list.setMaxResults(Long.valueOf(1L));
        TableDataList dataList = (TableDataList)list.execute();
        return dataList.getRows() == null || dataList.getRows().isEmpty();
    }

    @Nullable
    public Table tryCreateTable(TableReference ref, TableSchema schema) throws IOException {
        LOG.info("Trying to create BigQuery table: {}", (Object)BigQueryIO.toTableSpec(ref));
        Table content = new Table();
        content.setTableReference(ref);
        content.setSchema(schema);
        try {
            return (Table)this.client.tables().insert(ref.getProjectId(), ref.getDatasetId(), content).execute();
        }
        catch (IOException e) {
            if (new ApiErrorExtractor().itemAlreadyExists(e)) {
                LOG.info("The BigQuery table already exists.");
                return null;
            }
            throw e;
        }
    }
}

