/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BoundedQueueExecutor
extends ThreadPoolExecutor {
    private ReducableSemaphore semaphore;

    public BoundedQueueExecutor(int maximumPoolSize, long keepAliveTime, TimeUnit unit, int maximumQueueSize, ThreadFactory threadFactory) {
        super(maximumPoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>(), threadFactory);
        this.semaphore = new ReducableSemaphore(maximumQueueSize);
        this.allowCoreThreadTimeOut(true);
    }

    @Override
    public void execute(Runnable r) {
        this.semaphore.acquireUninterruptibly();
        super.execute(r);
    }

    public void forceExecute(Runnable r) {
        this.semaphore.reducePermits(1);
        super.execute(r);
    }

    @Override
    public void beforeExecute(Thread t, Runnable r) {
        this.semaphore.release();
    }

    private static class ReducableSemaphore
    extends Semaphore {
        ReducableSemaphore(int permits) {
            super(permits);
        }

        @Override
        public void reducePermits(int permits) {
            super.reducePermits(permits);
        }
    }
}

