/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.services.dataflow.model.MetricStructuredName;
import com.google.api.services.dataflow.model.MetricUpdate;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.common.Counter;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudCounterUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CloudCounterUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MetricUpdate> extractCounters(CounterSet counters, boolean delta) {
        CounterSet counterSet = counters;
        synchronized (counterSet) {
            ArrayList<MetricUpdate> cloudCounters = new ArrayList<MetricUpdate>(counters.size());
            for (Counter<?> counter : counters) {
                try {
                    MetricUpdate cloudCounter = CloudCounterUtils.extractCounter(counter, delta);
                    if (cloudCounter == null) continue;
                    cloudCounters.add(cloudCounter);
                }
                catch (IllegalArgumentException exn) {
                    LOG.warn("Error extracting counter value: ", (Throwable)exn);
                }
            }
            return cloudCounters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetricUpdate extractCounter(Counter<?> counter, boolean delta) {
        Counter<?> counter2 = counter;
        synchronized (counter2) {
            MetricStructuredName name = new MetricStructuredName();
            name.setName(counter.getName());
            MetricUpdate metricUpdate = new MetricUpdate().setName(name).setKind(counter.getKind().name()).setCumulative(Boolean.valueOf(!delta));
            switch (counter.getKind()) {
                case SUM: 
                case MAX: 
                case MIN: 
                case AND: 
                case OR: {
                    Object aggregate = delta ? counter.getAndResetDelta() : counter.getAggregate();
                    metricUpdate.setScalar((Object)CloudObject.forKnownType(aggregate));
                    break;
                }
                case MEAN: {
                    Counter.CounterMean<?> mean = delta ? counter.getAndResetMeanDelta() : counter.getMean();
                    if (mean.getCount() <= 0L) {
                        return null;
                    }
                    metricUpdate.setMeanSum((Object)CloudObject.forKnownType(mean.getAggregate()));
                    metricUpdate.setMeanCount((Object)CloudObject.forKnownType(mean.getCount()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected kind of counter");
                }
            }
            return metricUpdate;
        }
    }
}

