/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.services.dataflow.model.MetricStructuredName;
import com.google.api.services.dataflow.model.MetricUpdate;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.common.Metric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class CloudMetricUtils {
    private CloudMetricUtils() {
    }

    public static List<MetricUpdate> extractCloudMetrics(Collection<Metric<?>> metrics, String workerId) {
        ArrayList<MetricUpdate> cloudMetrics = new ArrayList<MetricUpdate>(metrics.size());
        for (Metric<?> metric : metrics) {
            cloudMetrics.add(CloudMetricUtils.extractCloudMetric(metric, workerId));
        }
        return cloudMetrics;
    }

    public static MetricUpdate extractCloudMetric(Metric<?> metric, String workerId) {
        if (metric instanceof Metric.DoubleMetric) {
            return CloudMetricUtils.extractCloudMetric(metric, (Double)((Metric.DoubleMetric)metric).getValue(), workerId);
        }
        throw new IllegalArgumentException("unexpected kind of Metric");
    }

    private static MetricUpdate extractCloudMetric(Metric<?> metric, Double value, String workerId) {
        MetricStructuredName name = new MetricStructuredName();
        name.setName(metric.getName());
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("workerId", workerId);
        name.setContext(context);
        return new MetricUpdate().setName(name).setScalar((Object)CloudObject.forFloat(value));
    }
}

