/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.transforms.Aggregator;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.util.common.Counter;
import com.google.cloud.dataflow.sdk.util.common.CounterProvider;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;

public class CounterAggregator<InputT, AccumT, OutputT>
implements Aggregator<InputT, OutputT> {
    private final Counter<InputT> counter;
    private final Combine.CombineFn<InputT, AccumT, OutputT> combiner;

    public CounterAggregator(String name, Combine.CombineFn<? super InputT, AccumT, OutputT> combiner, CounterSet.AddCounterMutator addCounterMutator) {
        this(CounterAggregator.constructCounter(name, combiner), addCounterMutator, combiner);
    }

    private CounterAggregator(Counter<InputT> counter, CounterSet.AddCounterMutator addCounterMutator, Combine.CombineFn<InputT, AccumT, OutputT> combiner) {
        try {
            this.counter = addCounterMutator.addCounter(counter);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("aggregator's name collides with an existing aggregator or system-provided counter of an incompatible type");
        }
        this.combiner = combiner;
    }

    private static <T> Counter<T> constructCounter(String name, Combine.CombineFn<? super T, ?, ?> combiner) {
        if (combiner instanceof CounterProvider) {
            CounterProvider counterProvider = (CounterProvider)((Object)combiner);
            return counterProvider.getCounter(name);
        }
        String string = String.valueOf(combiner.getClass().getName());
        throw new IllegalArgumentException(string.length() != 0 ? "unsupported combiner in Aggregator: ".concat(string) : new String("unsupported combiner in Aggregator: "));
    }

    @Override
    public void addValue(InputT value) {
        this.counter.addValue(value);
    }

    @Override
    public String getName() {
        return this.counter.getName();
    }

    @Override
    public Combine.CombineFn<InputT, ?, OutputT> getCombineFn() {
        return this.combiner;
    }
}

