/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ExecutableTrigger<W extends BoundedWindow>
implements Serializable {
    private final int triggerIndex;
    private final int firstIndexAfterSubtree;
    private final List<ExecutableTrigger<W>> subTriggers = new ArrayList<ExecutableTrigger<W>>();
    private final Trigger<W> trigger;

    public static <W extends BoundedWindow> ExecutableTrigger<W> create(Trigger<W> trigger) {
        return ExecutableTrigger.create(trigger, 0);
    }

    private static <W extends BoundedWindow> ExecutableTrigger<W> create(Trigger<W> trigger, int nextUnusedIndex) {
        if (trigger instanceof Trigger.OnceTrigger) {
            return new ExecutableOnceTrigger((Trigger.OnceTrigger)trigger, nextUnusedIndex);
        }
        return new ExecutableTrigger<W>(trigger, nextUnusedIndex);
    }

    public static <W extends BoundedWindow> ExecutableTrigger<W> createForOnceTrigger(Trigger.OnceTrigger<W> trigger, int nextUnusedIndex) {
        return new ExecutableOnceTrigger<W>(trigger, nextUnusedIndex);
    }

    private ExecutableTrigger(Trigger<W> trigger, int nextUnusedIndex) {
        this.trigger = trigger;
        this.triggerIndex = nextUnusedIndex++;
        if (trigger.subTriggers() != null) {
            for (Trigger<W> subTrigger : trigger.subTriggers()) {
                ExecutableTrigger<W> subExecutable = ExecutableTrigger.create(subTrigger, nextUnusedIndex);
                this.subTriggers.add(subExecutable);
                nextUnusedIndex = subExecutable.firstIndexAfterSubtree;
            }
        }
        this.firstIndexAfterSubtree = nextUnusedIndex;
    }

    public List<ExecutableTrigger<W>> subTriggers() {
        return this.subTriggers;
    }

    public String toString() {
        return this.trigger.toString();
    }

    public Trigger<W> getSpec() {
        return this.trigger;
    }

    public int getTriggerIndex() {
        return this.triggerIndex;
    }

    public final int getFirstIndexAfterSubtree() {
        return this.firstIndexAfterSubtree;
    }

    public boolean isCompatible(ExecutableTrigger<W> other) {
        return this.trigger.isCompatible(other.trigger);
    }

    public ExecutableTrigger<W> getSubTriggerContaining(int index) {
        Preconditions.checkNotNull(this.subTriggers);
        Preconditions.checkState(index > this.triggerIndex && index < this.firstIndexAfterSubtree, "Cannot find sub-trigger containing index not in this tree.");
        ExecutableTrigger<W> previous = null;
        for (ExecutableTrigger<W> subTrigger : this.subTriggers) {
            if (index < subTrigger.triggerIndex) {
                return previous;
            }
            previous = subTrigger;
        }
        return previous;
    }

    public Trigger.TriggerResult invokeElement(Trigger.OnElementContext c) throws Exception {
        Trigger.TriggerContext subContext = c.forTrigger(this);
        if (subContext.trigger().isFinished()) {
            throw new IllegalStateException("Shouldn't invokeElement on finished triggers.");
        }
        Trigger.TriggerResult result = this.trigger.onElement((Trigger.OnElementContext)subContext);
        if (result.isFinish()) {
            subContext.trigger().setFinished(true);
        }
        return result;
    }

    public Trigger.TriggerResult invokeTimer(Trigger.OnTimerContext c) throws Exception {
        Trigger.TriggerContext subContext = c.forTrigger(this);
        if (subContext.trigger().isFinished()) {
            throw new IllegalStateException("Shouldn't invokeTimer on finished triggers.");
        }
        Trigger.TriggerResult result = this.trigger.onTimer((Trigger.OnTimerContext)subContext);
        if (result.isFinish()) {
            subContext.trigger().setFinished(true);
        }
        return result;
    }

    public Trigger.MergeResult invokeMerge(Trigger.OnMergeContext c) throws Exception {
        Trigger.TriggerContext subContext = c.forTrigger(this);
        Trigger.MergeResult result = this.trigger.onMerge((Trigger.OnMergeContext)subContext);
        ((Trigger.OnMergeContext)subContext).trigger().setFinished(result.isFinish());
        return result;
    }

    public void invokeClear(Trigger.TriggerContext c) throws Exception {
        this.trigger.clear(c.forTrigger(this));
    }

    private static class ExecutableOnceTrigger<W extends BoundedWindow>
    extends ExecutableTrigger<W> {
        public ExecutableOnceTrigger(Trigger.OnceTrigger<W> trigger, int nextUnusedIndex) {
            super(trigger, nextUnusedIndex);
        }

        @Override
        public Trigger.TriggerResult invokeElement(Trigger.OnElementContext c) throws Exception {
            Trigger.TriggerResult result = super.invokeElement(c);
            if (Trigger.TriggerResult.FIRE.equals((Object)result)) {
                throw new IllegalStateException("TriggerResult.FIRE returned from once trigger");
            }
            return result;
        }

        @Override
        public Trigger.TriggerResult invokeTimer(Trigger.OnTimerContext c) throws Exception {
            Trigger.TriggerResult result = super.invokeTimer(c);
            if (Trigger.TriggerResult.FIRE.equals((Object)result)) {
                throw new IllegalStateException("TriggerResult.FIRE returned from once trigger");
            }
            return result;
        }

        @Override
        public Trigger.MergeResult invokeMerge(Trigger.OnMergeContext c) throws Exception {
            Trigger.MergeResult result = super.invokeMerge(c);
            if (Trigger.MergeResult.FIRE.equals((Object)result)) {
                throw new IllegalStateException("MergeResult.FIRE returned from once trigger");
            }
            return result;
        }
    }
}

