/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.services.dataflow.model.DataflowPackage;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineDebugOptions;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.util.PackageUtil;
import com.google.cloud.dataflow.sdk.util.Stager;
import java.util.List;

public class GcsStager
implements Stager {
    private DataflowPipelineOptions options;

    private GcsStager(DataflowPipelineOptions options) {
        this.options = options;
    }

    public static GcsStager fromOptions(PipelineOptions options) {
        return new GcsStager(options.as(DataflowPipelineOptions.class));
    }

    @Override
    public List<DataflowPackage> stageFiles() {
        Preconditions.checkNotNull(this.options.getStagingLocation());
        List<String> filesToStage = this.options.getFilesToStage();
        String windmillBinary = this.options.as(DataflowPipelineDebugOptions.class).getOverrideWindmillBinary();
        if (windmillBinary != null) {
            String string = String.valueOf(windmillBinary);
            filesToStage.add(string.length() != 0 ? "windmill_main=".concat(string) : new String("windmill_main="));
        }
        return PackageUtil.stageClasspathElements(this.options.getFilesToStage(), this.options.getStagingLocation());
    }
}

