/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ArrayListMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.DefaultTrigger;
import com.google.cloud.dataflow.sdk.transforms.windowing.PaneInfo;
import com.google.cloud.dataflow.sdk.util.GroupAlsoByWindowsDoFn;
import com.google.cloud.dataflow.sdk.util.SystemDoFnInternal;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.common.PeekingReiterator;
import com.google.cloud.dataflow.sdk.util.common.Reiterable;
import com.google.cloud.dataflow.sdk.util.common.Reiterator;
import com.google.cloud.dataflow.sdk.values.KV;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

@SystemDoFnInternal
class GroupAlsoByWindowsViaIteratorsDoFn<K, V, W extends BoundedWindow>
extends GroupAlsoByWindowsDoFn<K, V, Iterable<V>, W> {
    private final WindowingStrategy<?, W> strategy;

    public static boolean isSupported(WindowingStrategy<?, ?> strategy) {
        if (!strategy.getWindowFn().isNonMerging()) {
            return false;
        }
        if (!(strategy.getTrigger().getSpec() instanceof DefaultTrigger)) {
            return false;
        }
        return strategy.getMode().equals((Object)WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES) || strategy.getMode().equals((Object)WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES);
    }

    public GroupAlsoByWindowsViaIteratorsDoFn(WindowingStrategy<?, W> strategy) {
        this.strategy = strategy;
    }

    @Override
    public void processElement(DoFn.ProcessContext c) throws Exception {
        Reiterator<Object> iterator;
        Object key = ((KV)c.element()).getKey();
        Iterable value = (Iterable)((KV)c.element()).getValue();
        if (value instanceof Collection) {
            iterator = new PeekingReiterator(new ListReiterator(new ArrayList((Collection)value), 0));
        } else if (value instanceof Reiterable) {
            iterator = new PeekingReiterator(((Reiterable)value).iterator());
        } else {
            throw new IllegalArgumentException("Input to GroupAlsoByWindowsDoFn must be a Collection or Reiterable");
        }
        ArrayListMultimap<Instant, BoundedWindow> windows = ArrayListMultimap.create();
        while (((PeekingReiterator)iterator).hasNext()) {
            WindowedValue e = (WindowedValue)((PeekingReiterator)iterator).peek();
            for (BoundedWindow window : e.getWindows()) {
                if (windows.containsEntry(window.maxTimestamp(), window)) continue;
                BoundedWindow typedWindow = window;
                windows.put(window.maxTimestamp(), window);
                c.windowingInternals().outputWindowedValue(KV.of(key, new WindowReiterable(iterator, window)), this.strategy.getWindowFn().getOutputTime(e.getTimestamp(), typedWindow), Arrays.asList(window), PaneInfo.ON_TIME_AND_ONLY_FIRING);
            }
            if (((PeekingReiterator)(iterator = ((PeekingReiterator)iterator).copy())).hasNext() && ((PeekingReiterator)iterator).peek() == e) {
                ((PeekingReiterator)iterator).next();
            }
            Iterator windowIterator = windows.keys().iterator();
            while (windowIterator.hasNext() && ((Instant)windowIterator.next()).isBefore((ReadableInstant)e.getTimestamp())) {
                windowIterator.remove();
            }
        }
    }

    private static class ListReiterator<T>
    implements Reiterator<T> {
        private List<T> list;
        private int index;

        public ListReiterator(List<T> list, int index) {
            this.list = list;
            this.index = index;
        }

        @Override
        public T next() {
            return this.list.get(this.index++);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reiterator<T> copy() {
            return new ListReiterator<T>(this.list, this.index);
        }
    }

    private static class WindowReiterator<V>
    implements Reiterator<V> {
        private PeekingReiterator<WindowedValue<V>> iterator;
        private BoundedWindow window;

        public WindowReiterator(PeekingReiterator<WindowedValue<V>> iterator, BoundedWindow window) {
            this.iterator = iterator;
            this.window = window;
        }

        @Override
        public Reiterator<V> copy() {
            return new WindowReiterator<V>(this.iterator.copy(), this.window);
        }

        @Override
        public boolean hasNext() {
            this.skipToValidElement();
            return this.iterator.hasNext() && this.iterator.peek().getWindows().contains(this.window);
        }

        @Override
        public V next() {
            this.skipToValidElement();
            WindowedValue<V> next = this.iterator.next();
            if (!next.getWindows().contains(this.window)) {
                throw new NoSuchElementException("No next item in window");
            }
            return next.getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void skipToValidElement() {
            WindowedValue<V> peek;
            while (this.iterator.hasNext() && !(peek = this.iterator.peek()).getTimestamp().isAfter((ReadableInstant)this.window.maxTimestamp())) {
                if (peek.getWindows().size() != 1 || !peek.getWindows().contains(this.window)) {
                    this.iterator = this.iterator.copy();
                }
                if (peek.getWindows().contains(this.window)) break;
                this.iterator.next();
            }
        }
    }

    private static class WindowReiterable<V>
    implements Reiterable<V> {
        private PeekingReiterator<WindowedValue<V>> baseIterator;
        private BoundedWindow window;

        public WindowReiterable(PeekingReiterator<WindowedValue<V>> baseIterator, BoundedWindow window) {
            this.baseIterator = baseIterator;
            this.window = window;
        }

        @Override
        public Reiterator<V> iterator() {
            WindowReiterator<V> result = new WindowReiterator<V>(this.baseIterator, this.window);
            this.baseIterator = this.baseIterator.copy();
            return result;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).addValue(Iterables.toString(this)).toString();
        }
    }
}

