/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Joiner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public class InstanceBuilder<T> {
    private final Class<T> type;
    private final List<Class<?>> parameterTypes = new LinkedList();
    private final List<Object> arguments = new LinkedList<Object>();
    @Nullable
    private String methodName;
    @Nullable
    private Class<?> factoryClass;

    public static <T> InstanceBuilder<T> ofType(Class<T> type) {
        return new InstanceBuilder<T>(type);
    }

    public static <T> InstanceBuilder<T> ofType(TypeDescriptor<T> token) {
        Class<T> type = token.getRawType();
        return new InstanceBuilder<T>(type);
    }

    public InstanceBuilder<T> fromClassName(String name) throws ClassNotFoundException {
        Preconditions.checkArgument(this.factoryClass == null, "Class name may only be specified once");
        if (name.indexOf(46) == -1) {
            String string = String.valueOf(this.type.getPackage().getName());
            String string2 = name;
            name = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString();
        }
        try {
            this.factoryClass = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException(String.format("Could not find class: %s", name), e);
        }
        return this;
    }

    public InstanceBuilder<T> fromClass(Class<?> factoryClass) {
        this.factoryClass = factoryClass;
        return this;
    }

    public InstanceBuilder<T> fromFactoryMethod(String methodName) {
        Preconditions.checkArgument(this.methodName == null, "Factory method name may only be specified once");
        this.methodName = methodName;
        return this;
    }

    public <ArgT> InstanceBuilder<T> withArg(Class<? super ArgT> argType, ArgT value) {
        this.parameterTypes.add(argType);
        this.arguments.add(value);
        return this;
    }

    public T build() {
        if (this.factoryClass == null) {
            this.factoryClass = this.type;
        }
        Class[] types = this.parameterTypes.toArray(new Class[this.parameterTypes.size()]);
        if (this.methodName != null) {
            return this.buildFromMethod(types);
        }
        return this.buildFromConstructor(types);
    }

    private InstanceBuilder(Class<T> type) {
        this.type = type;
    }

    private T buildFromMethod(Class<?>[] types) {
        Preconditions.checkState(this.factoryClass != null);
        Preconditions.checkState(this.methodName != null);
        try {
            Method method = this.factoryClass.getDeclaredMethod(this.methodName, types);
            String string = String.valueOf(this.factoryClass.getName());
            String string2 = String.valueOf(method.getName());
            Preconditions.checkState(Modifier.isStatic(method.getModifiers()), new StringBuilder(44 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Factory method must be a static method for ").append(string).append("#").append(string2).toString());
            string = String.valueOf(this.factoryClass.getName());
            string2 = String.valueOf(method.getName());
            String string3 = String.valueOf(this.type.getSimpleName());
            Preconditions.checkState(this.type.isAssignableFrom(method.getReturnType()), new StringBuilder(40 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Return type for ").append(string).append("#").append(string2).append(" must be assignable to ").append(string3).toString());
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Object[] args = this.arguments.toArray(new Object[this.arguments.size()]);
            return this.type.cast(method.invoke(null, args));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("Unable to find factory method %s#%s(%s)", this.factoryClass.getSimpleName(), this.methodName, Joiner.on(", ").join(types)));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(String.format("Failed to construct instance from factory method %s#%s(%s)", this.factoryClass.getSimpleName(), this.methodName, Joiner.on(", ").join(types)), e);
        }
    }

    private T buildFromConstructor(Class<?>[] types) {
        Preconditions.checkState(this.factoryClass != null);
        try {
            Constructor<?> constructor = this.factoryClass.getDeclaredConstructor(types);
            String string = String.valueOf(this.factoryClass.getName());
            String string2 = String.valueOf(this.type.getSimpleName());
            Preconditions.checkState(this.type.isAssignableFrom(this.factoryClass), new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Instance type ").append(string).append(" must be assignable to ").append(string2).toString());
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            Object[] args = this.arguments.toArray(new Object[this.arguments.size()]);
            return this.type.cast(constructor.newInstance(args));
        }
        catch (NoSuchMethodException e) {
            String string = String.valueOf(this.factoryClass.getName());
            throw new RuntimeException(string.length() != 0 ? "Unable to find constructor for ".concat(string) : new String("Unable to find constructor for "));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            String string = String.valueOf("Failed to construct instance from constructor ");
            String string3 = String.valueOf(this.factoryClass.getName());
            throw new RuntimeException(string3.length() != 0 ? string.concat(string3) : new String(string), e);
        }
    }
}

