/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.MapCoder;
import com.google.cloud.dataflow.sdk.coders.SetCoder;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.WindowFn;
import com.google.cloud.dataflow.sdk.util.ActiveWindowSet;
import com.google.cloud.dataflow.sdk.util.state.StateInternals;
import com.google.cloud.dataflow.sdk.util.state.StateNamespaces;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import com.google.cloud.dataflow.sdk.util.state.StateTags;
import com.google.cloud.dataflow.sdk.util.state.ValueState;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MergingActiveWindowSet<W extends BoundedWindow>
implements ActiveWindowSet<W> {
    private final WindowFn<Object, W> windowFn;
    private final Map<W, Set<W>> mergeTree;
    private final Map<W, Set<W>> originalMergeTree;
    private final ValueState<Map<W, Set<W>>> mergeTreeValue;

    public MergingActiveWindowSet(WindowFn<Object, W> windowFn, StateInternals state) {
        this.windowFn = windowFn;
        StateTag mergeTreeAddr = StateTags.makeSystemTagInternal(StateTags.value("tree", MapCoder.of(windowFn.windowCoder(), SetCoder.of(windowFn.windowCoder()))));
        this.mergeTreeValue = state.state(StateNamespaces.global(), mergeTreeAddr);
        this.mergeTree = MergingActiveWindowSet.emptyIfNull(this.mergeTreeValue.get().read());
        this.originalMergeTree = this.deepCopy(this.mergeTree);
    }

    @Override
    public void persist() {
        if (!this.mergeTree.equals(this.originalMergeTree)) {
            this.mergeTreeValue.set(this.mergeTree);
        }
    }

    @Override
    public boolean add(W window) {
        if (this.mergeTree.containsKey(window)) {
            return false;
        }
        this.mergeTree.put(window, new HashSet());
        return true;
    }

    @Override
    public void remove(W window) {
        this.mergeTree.remove(window);
    }

    @Override
    public boolean mergeIfAppropriate(W window, ActiveWindowSet.MergeCallback<W> mergeCallback) throws Exception {
        this.windowFn.mergeWindows(new MergeContextImpl(mergeCallback));
        return window == null || this.mergeTree.containsKey(window);
    }

    @Override
    public Iterable<W> sourceWindows(W window) {
        HashSet<W> curWindows = new HashSet<W>();
        curWindows.add(window);
        Set<W> sourceWindows = this.mergeTree.get(window);
        if (sourceWindows != null) {
            curWindows.addAll(sourceWindows);
        }
        return curWindows;
    }

    private void recordMerge(Collection<W> otherWindows, W newWindow) throws Exception {
        Set<W> subWindows = this.mergeTree.get(newWindow);
        if (subWindows == null) {
            subWindows = new HashSet<W>();
        }
        for (BoundedWindow other : otherWindows) {
            if (!this.mergeTree.containsKey(other)) {
                String string = String.valueOf(other);
                throw new IllegalArgumentException(new StringBuilder(38 + String.valueOf(string).length()).append("Tried to merge a non-existent window: ").append(string).toString());
            }
            subWindows.addAll((Collection)this.mergeTree.get(other));
            subWindows.add(other);
            this.mergeTree.remove(other);
        }
        this.mergeTree.put(newWindow, subWindows);
    }

    private static <W> Map<W, Set<W>> emptyIfNull(Map<W, Set<W>> input) {
        if (input == null) {
            return new HashMap();
        }
        for (Map.Entry<W, Set<W>> entry : input.entrySet()) {
            if (entry.getValue() != null) continue;
            entry.setValue(new HashSet());
        }
        return input;
    }

    private Map<W, Set<W>> deepCopy(Map<W, Set<W>> mergeTree) {
        HashMap newMergeTree = new HashMap();
        for (Map.Entry<W, Set<W>> entry : mergeTree.entrySet()) {
            newMergeTree.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return newMergeTree;
    }

    static /* synthetic */ WindowFn access$000(MergingActiveWindowSet x0) {
        return x0.windowFn;
    }

    private class MergeContextImpl
    extends WindowFn.MergeContext {
        private ActiveWindowSet.MergeCallback<W> mergeCallback;

        public MergeContextImpl(ActiveWindowSet.MergeCallback<W> mergeCallback) {
            this.mergeCallback = mergeCallback;
        }

        @Override
        public Collection<W> windows() {
            return MergingActiveWindowSet.this.mergeTree.keySet();
        }

        @Override
        public void merge(Collection<W> toBeMerged, W mergeResult) throws Exception {
            boolean isResultNew = !MergingActiveWindowSet.this.mergeTree.containsKey(mergeResult);
            MergingActiveWindowSet.this.recordMerge(toBeMerged, mergeResult);
            this.mergeCallback.onMerge(toBeMerged, mergeResult, isResultNew);
        }
    }
}

