/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.VarLongCoder;
import com.google.cloud.dataflow.sdk.transforms.Sum;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.ReduceFn;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.state.CombiningValueState;
import com.google.cloud.dataflow.sdk.util.state.StateContents;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import com.google.cloud.dataflow.sdk.util.state.StateTags;

public abstract class NonEmptyPanes<W extends BoundedWindow> {
    public static <W extends BoundedWindow> NonEmptyPanes<W> create(WindowingStrategy<?, W> strategy, ReduceFn<?, ?, ?, W> reduceFn) {
        if (strategy.getMode() == WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES) {
            return new DiscardingModeNonEmptyPanes(reduceFn);
        }
        return new GeneralNonEmptyPanes();
    }

    public abstract void recordContent(ReduceFn.Context var1);

    public abstract void clearPane(ReduceFn.Context var1);

    public abstract StateContents<Boolean> isEmpty(ReduceFn.Context var1);

    private static class GeneralNonEmptyPanes<W extends BoundedWindow>
    extends NonEmptyPanes<W> {
        private static final StateTag<CombiningValueState<Long, Long>> PANE_ADDITIONS_TAG = StateTags.makeSystemTagInternal(StateTags.combiningValueFromInputInternal("count", VarLongCoder.of(), new Sum.SumLongFn()));

        private GeneralNonEmptyPanes() {
        }

        @Override
        public void recordContent(ReduceFn.Context context) {
            context.state().access(PANE_ADDITIONS_TAG).add(1L);
        }

        @Override
        public void clearPane(ReduceFn.Context context) {
            context.state().accessAcrossMergedWindows(PANE_ADDITIONS_TAG).clear();
        }

        @Override
        public StateContents<Boolean> isEmpty(ReduceFn.Context context) {
            return context.state().accessAcrossMergedWindows(PANE_ADDITIONS_TAG).isEmpty();
        }
    }

    private static class DiscardingModeNonEmptyPanes<W extends BoundedWindow>
    extends NonEmptyPanes<W> {
        private ReduceFn<?, ?, ?, W> reduceFn;

        private DiscardingModeNonEmptyPanes(ReduceFn<?, ?, ?, W> reduceFn) {
            this.reduceFn = reduceFn;
        }

        @Override
        public StateContents<Boolean> isEmpty(ReduceFn.Context context) {
            return this.reduceFn.isEmpty(context.state());
        }

        @Override
        public void recordContent(ReduceFn.Context context) {
        }

        @Override
        public void clearPane(ReduceFn.Context context) {
        }
    }
}

