/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.PaneInfo;
import com.google.cloud.dataflow.sdk.util.ActiveWindowSet;
import com.google.cloud.dataflow.sdk.util.ReduceFn;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import com.google.cloud.dataflow.sdk.util.TimerInternals;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.state.MergeableState;
import com.google.cloud.dataflow.sdk.util.state.State;
import com.google.cloud.dataflow.sdk.util.state.StateContents;
import com.google.cloud.dataflow.sdk.util.state.StateInternals;
import com.google.cloud.dataflow.sdk.util.state.StateNamespace;
import com.google.cloud.dataflow.sdk.util.state.StateNamespaces;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.joda.time.Instant;

class ReduceFnContextFactory<K, InputT, OutputT, W extends BoundedWindow> {
    private final K key;
    private final ReduceFn<K, InputT, OutputT, W> reduceFn;
    private final WindowingStrategy<?, W> windowingStrategy;
    private StateInternals stateInternals;
    private ActiveWindowSet<W> activeWindows;
    private TimerInternals timerInternals;

    ReduceFnContextFactory(K key, ReduceFn<K, InputT, OutputT, W> reduceFn, WindowingStrategy<?, W> windowingStrategy, StateInternals stateInternals, ActiveWindowSet<W> activeWindows, TimerInternals timerInternals) {
        this.key = key;
        this.reduceFn = reduceFn;
        this.windowingStrategy = windowingStrategy;
        this.stateInternals = stateInternals;
        this.activeWindows = activeWindows;
        this.timerInternals = timerInternals;
    }

    private StateContextImpl<W> stateContext(W window) {
        return new StateContextImpl<W>(this.activeWindows, this.windowingStrategy.getWindowFn().windowCoder(), this.stateInternals, window);
    }

    public ReduceFn.Context base(W window) {
        return new ContextImpl(this.stateContext(window));
    }

    public ReduceFn.ProcessValueContext forValue(W window, InputT value, Instant timestamp) {
        return new ProcessValueContextImpl(this.stateContext(window), value, timestamp);
    }

    public ReduceFn.OnTriggerContext forTrigger(W window, StateContents<PaneInfo> pane, OnTriggerCallbacks<OutputT> callbacks) {
        return new OnTriggerContextImpl(this.stateContext(window), pane, callbacks);
    }

    public ReduceFn.OnMergeContext forMerge(Collection<W> mergingWindows, W resultWindow) {
        return new OnMergeContextImpl(new MergingStateContextImpl<W>(this.stateContext(resultWindow), mergingWindows));
    }

    private class OnMergeContextImpl
    extends ReduceFn.OnMergeContext {
        private final MergingStateContextImpl<W> state;
        private final TimersImpl timers;

        private OnMergeContextImpl(MergingStateContextImpl<W> state) {
            super(ReduceFnContextFactory.this.reduceFn);
            this.state = state;
            this.timers = new TimersImpl(state.delegate.namespace);
        }

        @Override
        public K key() {
            return ReduceFnContextFactory.this.key;
        }

        @Override
        public WindowingStrategy<?, W> windowingStrategy() {
            return ReduceFnContextFactory.this.windowingStrategy;
        }

        @Override
        public ReduceFn.MergingStateContext state() {
            return this.state;
        }

        @Override
        public Collection<W> mergingWindows() {
            return this.state.mergingWindows;
        }

        @Override
        public W window() {
            return this.state.delegate.window;
        }

        @Override
        public ReduceFn.Timers timers() {
            return this.timers;
        }
    }

    private class OnTriggerContextImpl
    extends ReduceFn.OnTriggerContext {
        private final StateContextImpl<W> state;
        private final StateContents<PaneInfo> pane;
        private final OnTriggerCallbacks<OutputT> callbacks;
        private final TimersImpl timers;

        private OnTriggerContextImpl(StateContextImpl<W> state, StateContents<PaneInfo> pane, OnTriggerCallbacks<OutputT> callbacks) {
            super(ReduceFnContextFactory.this.reduceFn);
            this.state = state;
            this.pane = pane;
            this.callbacks = callbacks;
            this.timers = new TimersImpl(state.namespace);
        }

        @Override
        public K key() {
            return ReduceFnContextFactory.this.key;
        }

        @Override
        public W window() {
            return this.state.window;
        }

        @Override
        public WindowingStrategy<?, W> windowingStrategy() {
            return ReduceFnContextFactory.this.windowingStrategy;
        }

        @Override
        public ReduceFn.StateContext state() {
            return this.state;
        }

        @Override
        public PaneInfo paneInfo() {
            return this.pane.read();
        }

        @Override
        public void output(OutputT value) {
            this.callbacks.output(value);
        }

        @Override
        public ReduceFn.Timers timers() {
            return this.timers;
        }
    }

    private class ProcessValueContextImpl
    extends ReduceFn.ProcessValueContext {
        private final InputT value;
        private final Instant timestamp;
        private final StateContextImpl<W> state;
        private final TimersImpl timers;

        private ProcessValueContextImpl(StateContextImpl<W> state, InputT value, Instant timestamp) {
            super(ReduceFnContextFactory.this.reduceFn);
            this.state = state;
            this.value = value;
            this.timestamp = timestamp;
            this.timers = new TimersImpl(state.namespace);
        }

        @Override
        public K key() {
            return ReduceFnContextFactory.this.key;
        }

        @Override
        public W window() {
            return this.state.window;
        }

        @Override
        public WindowingStrategy<?, W> windowingStrategy() {
            return ReduceFnContextFactory.this.windowingStrategy;
        }

        @Override
        public ReduceFn.StateContext state() {
            return this.state;
        }

        @Override
        public InputT value() {
            return this.value;
        }

        @Override
        public Instant timestamp() {
            return this.timestamp;
        }

        @Override
        public ReduceFn.Timers timers() {
            return this.timers;
        }
    }

    private class ContextImpl
    extends ReduceFn.Context {
        private final StateContextImpl<W> state;
        private final TimersImpl timers;

        private ContextImpl(StateContextImpl<W> state) {
            super(ReduceFnContextFactory.this.reduceFn);
            this.state = state;
            this.timers = new TimersImpl(state.namespace);
        }

        @Override
        public K key() {
            return ReduceFnContextFactory.this.key;
        }

        @Override
        public W window() {
            return this.state.window;
        }

        @Override
        public WindowingStrategy<?, W> windowingStrategy() {
            return ReduceFnContextFactory.this.windowingStrategy;
        }

        @Override
        public ReduceFn.StateContext state() {
            return this.state;
        }

        @Override
        public ReduceFn.Timers timers() {
            return this.timers;
        }
    }

    static class MergingStateContextImpl<W extends BoundedWindow>
    implements ReduceFn.MergingStateContext {
        private final StateContextImpl<W> delegate;
        private final Collection<W> mergingWindows;

        public MergingStateContextImpl(StateContextImpl<W> delegate, Collection<W> mergingWindows) {
            this.delegate = delegate;
            this.mergingWindows = mergingWindows;
        }

        StateNamespace namespace() {
            return this.delegate.namespace;
        }

        W window() {
            return this.delegate.window();
        }

        Collection<W> mergingWindows() {
            return this.mergingWindows;
        }

        public <StorageT extends State> StorageT access(StateTag<StorageT> address) {
            return this.delegate.access(address);
        }

        public <StorageT extends MergeableState<?, ?>> StorageT accessAcrossMergedWindows(StateTag<StorageT> address) {
            return this.delegate.accessAcrossMergedWindows(address);
        }

        @Override
        public <StateT extends MergeableState<?, ?>> StateT accessAcrossMergingWindows(StateTag<StateT> address) {
            ArrayList<StateNamespace> mergingNamespaces = new ArrayList<StateNamespace>();
            for (BoundedWindow mergingWindow : this.mergingWindows) {
                mergingNamespaces.add(this.delegate.namespaceFor(mergingWindow));
            }
            return ((StateContextImpl)this.delegate).stateInternals.mergedState(mergingNamespaces, this.delegate.namespace, address);
        }

        @Override
        public <StateT extends State> Map<BoundedWindow, StateT> accessInEachMergingWindow(StateTag<StateT> address) {
            ImmutableMap.Builder<BoundedWindow, StateT> builder = ImmutableMap.builder();
            for (BoundedWindow mergingWindow : this.mergingWindows) {
                StateT stateForWindow = ((StateContextImpl)this.delegate).stateInternals.state(this.delegate.namespaceFor(mergingWindow), address);
                builder.put(mergingWindow, stateForWindow);
            }
            return builder.build();
        }
    }

    static class StateContextImpl<W extends BoundedWindow>
    implements ReduceFn.StateContext {
        private final ActiveWindowSet<W> activeWindows;
        private final W window;
        protected StateNamespace namespace;
        protected final Coder<W> windowCoder;
        private final StateInternals stateInternals;

        public StateContextImpl(ActiveWindowSet<W> activeWindows, Coder<W> windowCoder, StateInternals stateInternals, W window) {
            this.activeWindows = activeWindows;
            this.windowCoder = windowCoder;
            this.stateInternals = stateInternals;
            this.window = window;
            this.namespace = this.namespaceFor(window);
        }

        protected StateNamespace namespaceFor(W window) {
            return StateNamespaces.window(this.windowCoder, window);
        }

        W window() {
            return this.window;
        }

        StateNamespace namespace() {
            return this.namespace;
        }

        public <StorageT extends State> StorageT access(StateTag<StorageT> address) {
            return this.stateInternals.state(this.namespace, address);
        }

        public <StorageT extends MergeableState<?, ?>> StorageT accessAcrossMergedWindows(StateTag<StorageT> address) {
            ArrayList<StateNamespace> sourceNamespaces = new ArrayList<StateNamespace>();
            for (BoundedWindow sourceWindow : this.activeWindows.sourceWindows(this.window)) {
                sourceNamespaces.add(this.namespaceFor(sourceWindow));
            }
            return this.stateInternals.mergedState(sourceNamespaces, this.namespace, address);
        }
    }

    private class TimersImpl
    implements ReduceFn.Timers {
        private final StateNamespace namespace;

        public TimersImpl(StateNamespace namespace) {
            Preconditions.checkArgument(namespace instanceof StateNamespaces.WindowNamespace);
            this.namespace = namespace;
        }

        @Override
        public void setTimer(Instant timestamp, TimeDomain timeDomain) {
            ReduceFnContextFactory.this.timerInternals.setTimer(TimerInternals.TimerData.of(this.namespace, timestamp, timeDomain));
        }

        @Override
        public void deleteTimer(Instant timestamp, TimeDomain timeDomain) {
            ReduceFnContextFactory.this.timerInternals.deleteTimer(TimerInternals.TimerData.of(this.namespace, timestamp, timeDomain));
        }

        @Override
        public Instant currentProcessingTime() {
            return ReduceFnContextFactory.this.timerInternals.currentProcessingTime();
        }
    }

    public static interface OnTriggerCallbacks<OutputT> {
        public void output(OutputT var1);
    }
}

