/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

public class SerializableUtils {
    public static byte[] serializeToByteArray(Serializable value) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(buffer);){
                oos.writeObject(value);
            }
            return buffer.toByteArray();
        }
        catch (IOException exn) {
            String string = String.valueOf(value);
            throw new IllegalArgumentException(new StringBuilder(20 + String.valueOf(string).length()).append("unable to serialize ").append(string).toString(), exn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserializeFromByteArray(byte[] encodedValue, String description) {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(encodedValue));){
            Object object = ois.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException exn) {
            String string;
            String string2 = String.valueOf(description);
            if (string2.length() != 0) {
                string = "unable to deserialize ".concat(string2);
                throw new IllegalArgumentException(string, exn);
            }
            string = new String("unable to deserialize ");
            throw new IllegalArgumentException(string, exn);
        }
    }

    public static <T extends Serializable> T ensureSerializable(T value) {
        Serializable copy = (Serializable)SerializableUtils.deserializeFromByteArray(SerializableUtils.serializeToByteArray(value), value.toString());
        return (T)copy;
    }

    public static <T extends Serializable> T clone(T value) {
        Serializable copy = (Serializable)SerializableUtils.deserializeFromByteArray(SerializableUtils.serializeToByteArray(value), value.toString());
        return (T)copy;
    }

    public static CloudObject ensureSerializable(Coder<?> coder) {
        Coder decoded;
        Coder<?> copy = SerializableUtils.ensureSerializable(coder);
        CloudObject cloudObject = copy.asCloudObject();
        try {
            decoded = Serializer.deserialize((Map<String, Object>)((Object)cloudObject), Coder.class);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(String.format("Unable to deserialize Coder: %s. Check that a suitable constructor is defined.  See Coder for details.", coder), e);
        }
        Preconditions.checkState(coder.equals(decoded), String.format("Coder not equal to original after serialization, indicating that the Coder may not implement serialization correctly.  Before: %s, after: %s, cloud encoding: %s", new Object[]{coder, decoded, cloudObject}));
        return cloudObject;
    }

    public static <T> T ensureSerializableByCoder(Coder<T> coder, T value, String errorContext) {
        byte[] encodedValue;
        try {
            encodedValue = CoderUtils.encodeToByteArray(coder, value);
        }
        catch (CoderException exn) {
            String string = String.valueOf(value);
            String string2 = String.valueOf(coder);
            throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(errorContext).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append(errorContext).append(": unable to encode value ").append(string).append(" using ").append(string2).toString(), exn);
        }
        try {
            return CoderUtils.decodeFromByteArray(coder, encodedValue);
        }
        catch (CoderException exn) {
            String string = String.valueOf(Arrays.toString(encodedValue));
            String string3 = String.valueOf(value);
            String string4 = String.valueOf(coder);
            throw new IllegalArgumentException(new StringBuilder(47 + String.valueOf(errorContext).length() + String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(errorContext).append(": unable to decode ").append(string).append(", encoding of value ").append(string3).append(", using ").append(string4).toString(), exn);
        }
    }
}

