/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.dataflow.sdk.util.CloudKnownType;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Serializer {
    public static <T> T deserialize(Map<String, Object> serialized, Class<T> clazz) {
        try {
            return (T)SingletonHelper.OBJECT_MAPPER.treeToValue((TreeNode)SingletonHelper.TREE_MAPPER.valueToTree(Serializer.deserializeCloudKnownTypes(serialized)), clazz);
        }
        catch (JsonProcessingException e) {
            String string = String.valueOf(clazz);
            throw new RuntimeException(new StringBuilder(28 + String.valueOf(string).length()).append("Unable to deserialize class ").append(string).toString(), e);
        }
    }

    private static Object deserializeCloudKnownTypes(Object src) {
        if (src instanceof Map) {
            Map srcMap = (Map)src;
            Object value = srcMap.get("value");
            CloudKnownType type = CloudKnownType.forUri((String)srcMap.get("@type"));
            if (type != null && value != null) {
                Object result = type.parse(value, type.defaultClass());
                return result;
            }
            HashMap dest = new HashMap(srcMap.size());
            for (Map.Entry entry : srcMap.entrySet()) {
                dest.put(entry.getKey(), Serializer.deserializeCloudKnownTypes(entry.getValue()));
            }
            return dest;
        }
        if (src instanceof List) {
            List srcList = (List)src;
            ArrayList<Object> dest = new ArrayList<Object>(srcList.size());
            for (Object obj : srcList) {
                dest.add(Serializer.deserializeCloudKnownTypes(obj));
            }
            return dest;
        }
        return src;
    }

    private static class SingletonHelper {
        static final ObjectMapper OBJECT_MAPPER = SingletonHelper.createObjectMapper();
        static final ObjectMapper TREE_MAPPER = SingletonHelper.createTreeMapper();

        private SingletonHelper() {
        }

        private static ObjectMapper createTreeMapper() {
            return new ObjectMapper();
        }

        private static ObjectMapper createObjectMapper() {
            ObjectMapper m = new ObjectMapper();
            m.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            m.enableDefaultTypingAsProperty(ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, "@type");
            m.registerModule((Module)new CoderUtils.Jackson2Module());
            return m;
        }
    }
}

