/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;

public class ShardingWritableByteChannel
implements WritableByteChannel {
    public static final int ALL_SHARDS = -2;
    private final ArrayList<WritableByteChannel> writers = new ArrayList();

    public int getNumShards() {
        return this.writers.size();
    }

    public void addChannel(WritableByteChannel writer) {
        this.writers.add(writer);
    }

    public WritableByteChannel getChannel(int shardNum) {
        return this.writers.get(shardNum);
    }

    public int writeToShard(int shardNum, ByteBuffer src) throws IOException {
        if (shardNum >= 0) {
            return this.writers.get(shardNum).write(src);
        }
        switch (shardNum) {
            case -2: {
                int size = 0;
                for (WritableByteChannel writer : this.writers) {
                    size += writer.write(src);
                }
                return size;
            }
        }
        throw new IllegalArgumentException(new StringBuilder(33).append("Illegal shard number: ").append(shardNum).toString());
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.writeToShard(-2, src);
    }

    @Override
    public boolean isOpen() {
        for (WritableByteChannel writer : this.writers) {
            if (writer.isOpen()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        for (WritableByteChannel writer : this.writers) {
            writer.close();
        }
    }
}

