/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import com.google.cloud.dataflow.sdk.util.state.StateNamespace;
import java.util.Objects;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public interface TimerInternals {
    public void setTimer(TimerData var1);

    public void deleteTimer(TimerData var1);

    public Instant currentProcessingTime();

    public Instant currentWatermarkTime();

    public static class TimerData
    implements Comparable<TimerData> {
        private final StateNamespace namespace;
        private final Instant timestamp;
        private final TimeDomain domain;

        private TimerData(StateNamespace namespace, Instant timestamp, TimeDomain domain) {
            this.namespace = namespace;
            this.timestamp = timestamp;
            this.domain = domain;
        }

        public StateNamespace getNamespace() {
            return this.namespace;
        }

        public Instant getTimestamp() {
            return this.timestamp;
        }

        public TimeDomain getDomain() {
            return this.domain;
        }

        public static TimerData of(StateNamespace namespace, Instant timestamp, TimeDomain domain) {
            return new TimerData(namespace, timestamp, domain);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TimerData)) {
                return false;
            }
            TimerData that = (TimerData)obj;
            return Objects.equals((Object)this.domain, (Object)that.domain) && this.timestamp.isEqual((ReadableInstant)that.timestamp) && Objects.equals(this.namespace, that.namespace);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.domain, this.timestamp, this.namespace});
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("namespace", this.namespace).add("timestamp", this.timestamp).add("domain", (Object)this.domain).toString();
        }

        @Override
        public int compareTo(TimerData o) {
            return Long.compare(this.timestamp.getMillis(), o.getTimestamp().getMillis());
        }
    }
}

