/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.DefaultTrigger;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.BitSetCoder;
import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import com.google.cloud.dataflow.sdk.util.ReduceFn;
import com.google.cloud.dataflow.sdk.util.TimerInternals;
import com.google.cloud.dataflow.sdk.util.TriggerContextFactory;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import com.google.cloud.dataflow.sdk.util.state.StateTags;
import com.google.cloud.dataflow.sdk.util.state.ValueState;
import java.util.BitSet;
import java.util.Map;

public class TriggerRunner<W extends BoundedWindow> {
    @VisibleForTesting
    static final StateTag<ValueState<BitSet>> FINISHED_BITS_TAG = StateTags.makeSystemTagInternal(StateTags.value("closed", BitSetCoder.of()));
    private final ExecutableTrigger<W> rootTrigger;
    private final TriggerContextFactory<W> contextFactory;

    public TriggerRunner(ExecutableTrigger<W> rootTrigger, TriggerContextFactory<W> contextFactory) {
        Preconditions.checkState(rootTrigger.getTriggerIndex() == 0);
        this.rootTrigger = rootTrigger;
        this.contextFactory = contextFactory;
    }

    private BitSet readFinishedBits(ValueState<BitSet> state) {
        if (!this.isFinishedSetNeeded()) {
            return new BitSet(this.rootTrigger.getFirstIndexAfterSubtree());
        }
        BitSet bitSet = state.get().read();
        return bitSet == null ? new BitSet(this.rootTrigger.getFirstIndexAfterSubtree()) : bitSet;
    }

    public boolean isClosed(ReduceFn.StateContext state) {
        return this.readFinishedBits(state.access(FINISHED_BITS_TAG)).get(0);
    }

    public Result processValue(ReduceFn.ProcessValueContext c) throws Exception {
        BitSet finishedSet = (BitSet)this.readFinishedBits(c.state().access(FINISHED_BITS_TAG)).clone();
        Trigger.OnElementContext triggerContext = this.contextFactory.create(c, this.rootTrigger, finishedSet);
        Trigger.TriggerResult result = this.rootTrigger.invokeElement(triggerContext);
        return new Result(result, this.isFinishedSetNeeded(), finishedSet);
    }

    public Result onMerge(ReduceFn.OnMergeContext c) throws Exception {
        BitSet finishedSet = (BitSet)this.readFinishedBits(c.state().access(FINISHED_BITS_TAG)).clone();
        ImmutableMap.Builder<BoundedWindow, BitSet> mergingFinishedSets = ImmutableMap.builder();
        Map<BoundedWindow, ValueState<BitSet>> mergingFinishedSetState = c.state().accessInEachMergingWindow(FINISHED_BITS_TAG);
        for (BoundedWindow window : c.mergingWindows()) {
            mergingFinishedSets.put(window, this.readFinishedBits(mergingFinishedSetState.get(window)));
        }
        Trigger.OnMergeContext mergeContext = this.contextFactory.create(c, this.rootTrigger, finishedSet, mergingFinishedSets.build());
        Trigger.MergeResult result = this.rootTrigger.invokeMerge(mergeContext);
        if (Trigger.MergeResult.ALREADY_FINISHED.equals((Object)result)) {
            throw new IllegalStateException("Root trigger returned MergeResult.ALREADY_FINISHED.");
        }
        return new Result(result.getTriggerResult(), this.isFinishedSetNeeded(), finishedSet);
    }

    public Result onTimer(ReduceFn.Context c, TimerInternals.TimerData timer) throws Exception {
        BitSet finishedSet = (BitSet)this.readFinishedBits(c.state().access(FINISHED_BITS_TAG)).clone();
        Trigger.OnTimerContext triggerContext = this.contextFactory.create(c, this.rootTrigger, finishedSet, timer.getTimestamp(), timer.getDomain());
        Trigger.TriggerResult result = this.rootTrigger.invokeTimer(triggerContext);
        return new Result(result, this.isFinishedSetNeeded(), finishedSet);
    }

    public void clearState(ReduceFn.Context c) throws Exception {
        BitSet finishedSet = this.readFinishedBits(c.state().access(FINISHED_BITS_TAG));
        this.rootTrigger.invokeClear(this.contextFactory.base(c, this.rootTrigger, finishedSet));
    }

    public void clearEverything(ReduceFn.Context c) throws Exception {
        this.clearState(c);
        if (this.isFinishedSetNeeded()) {
            c.state().access(FINISHED_BITS_TAG).clear();
        }
    }

    public void prefetchForValue(ReduceFn.StateContext state) {
        if (this.isFinishedSetNeeded()) {
            state.access(FINISHED_BITS_TAG).get();
        }
        this.rootTrigger.getSpec().prefetchOnElement(state);
    }

    public void prefetchForMerge(ReduceFn.MergingStateContext state) {
        if (this.isFinishedSetNeeded()) {
            for (ValueState<BitSet> value : state.accessInEachMergingWindow(FINISHED_BITS_TAG).values()) {
                value.get();
            }
        }
        this.rootTrigger.getSpec().prefetchOnMerge(state);
    }

    public void prefetchForTimer(ReduceFn.StateContext state) {
        if (this.isFinishedSetNeeded()) {
            state.access(FINISHED_BITS_TAG).get();
        }
        this.rootTrigger.getSpec().prefetchOnElement(state);
    }

    private boolean isFinishedSetNeeded() {
        return !(this.rootTrigger.getSpec() instanceof DefaultTrigger);
    }

    public static class Result {
        private final Trigger.TriggerResult result;
        private final boolean isFinishedSetUsed;
        private final BitSet modifiedFinishedSet;

        private Result(Trigger.TriggerResult result, boolean isFinishedSetUsed, BitSet modifiedFinishedSet) {
            this.result = result;
            this.isFinishedSetUsed = isFinishedSetUsed;
            this.modifiedFinishedSet = modifiedFinishedSet;
        }

        public boolean isFire() {
            return this.result.isFire();
        }

        public boolean isFinish() {
            return this.result.isFinish();
        }

        public void persistFinishedSet(ReduceFn.StateContext state) {
            if (!this.isFinishedSetUsed) {
                return;
            }
            ValueState<BitSet> finishedSet = state.access(FINISHED_BITS_TAG);
            if (!finishedSet.get().equals(this.modifiedFinishedSet)) {
                if (this.modifiedFinishedSet.isEmpty()) {
                    finishedSet.clear();
                } else {
                    finishedSet.set(this.modifiedFinishedSet);
                }
            }
        }
    }
}

