/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCodeException
extends RuntimeException {
    private static final Logger LOG = LoggerFactory.getLogger(UserCodeException.class);

    public UserCodeException(Throwable t) {
        super(t);
        StackTraceElement[] currentFrames = Thread.currentThread().getStackTrace();
        if (currentFrames.length <= 2) {
            LOG.error("Expecting stack trace to be > 2 frames long.");
            return;
        }
        if (!Objects.equals(currentFrames[1].getClassName(), this.getClass().getName())) {
            LOG.error("Expected second frame coming from Thread.currentThread.getStackTrace() to be {}, was: {}", (Object)this.getClass().getName(), (Object)currentFrames[1].getClassName());
            return;
        }
        if (Objects.equals(currentFrames[2].getClassName(), currentFrames[1].getClassName())) {
            LOG.error("Javac's Thread.CurrentThread.getStackTrace() changed unexpectedly.");
            return;
        }
        StackTraceElement callingFrame = currentFrames[2];
        this.truncateStackTrace(callingFrame, t);
    }

    private void truncateStackTrace(StackTraceElement currentFrame, Throwable t) {
        StackTraceElement[] stackTrace;
        int index = 0;
        for (StackTraceElement element : stackTrace = t.getStackTrace()) {
            if (Objects.equals(element.getClassName(), currentFrame.getClassName()) && Objects.equals(element.getMethodName(), currentFrame.getMethodName())) {
                t.setStackTrace(Arrays.copyOfRange(stackTrace, 0, index));
                break;
            }
            ++index;
        }
    }
}

