/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.util.CloudKnownType;
import java.util.Map;
import javax.annotation.Nullable;

public final class Values {
    private Values() {
    }

    public static Boolean asBoolean(Object value) throws ClassCastException {
        Boolean knownResult = Values.checkKnownValue(CloudKnownType.BOOLEAN, value, Boolean.class);
        if (knownResult != null) {
            return knownResult;
        }
        return (Boolean)Boolean.class.cast(value);
    }

    public static Double asDouble(Object value) throws ClassCastException {
        Double knownResult = Values.checkKnownValue(CloudKnownType.FLOAT, value, Double.class);
        if (knownResult != null) {
            return knownResult;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return ((Float)value).doubleValue();
    }

    public static Long asLong(Object value) throws ClassCastException {
        Long knownResult = Values.checkKnownValue(CloudKnownType.INTEGER, value, Long.class);
        if (knownResult != null) {
            return knownResult;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return ((Integer)value).longValue();
    }

    public static String asString(Object value) throws ClassCastException {
        String knownResult = Values.checkKnownValue(CloudKnownType.TEXT, value, String.class);
        if (knownResult != null) {
            return knownResult;
        }
        return (String)String.class.cast(value);
    }

    @Nullable
    private static <T> T checkKnownValue(CloudKnownType type, Object value, Class<T> clazz) {
        if (!(value instanceof Map)) {
            return null;
        }
        Map map = (Map)value;
        String typeName = (String)map.get("@type");
        if (typeName == null) {
            return null;
        }
        CloudKnownType knownType = CloudKnownType.forUri(typeName);
        if (knownType == null || knownType != type) {
            return null;
        }
        Object scalar = map.get("value");
        if (scalar == null) {
            return null;
        }
        return knownType.parse(scalar, clazz);
    }
}

