/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common;

import com.google.cloud.dataflow.sdk.util.common.Counter;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;

public class CounterSet
extends AbstractSet<Counter<?>> {
    private final HashMap<String, Counter<?>> counters = new HashMap();
    private final AddCounterMutator addCounterMutator = new AddCounterMutator();

    public CounterSet(Counter<?> ... counters) {
        for (Counter<?> counter : counters) {
            this.addNewCounter(counter);
        }
    }

    public AddCounterMutator getAddCounterMutator() {
        return this.addCounterMutator;
    }

    public void addNewCounter(Counter<?> counter) {
        if (!this.addCounter(counter)) {
            String string = String.valueOf(counter);
            String string2 = String.valueOf(this);
            throw new IllegalArgumentException(new StringBuilder(43 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Counter ").append(string).append(" duplicates an existing counter in ").append(string2).toString());
        }
    }

    public synchronized <T> Counter<T> addOrReuseCounter(Counter<T> counter) {
        Counter<?> oldCounter = this.counters.get(counter.getName());
        if (oldCounter == null) {
            this.counters.put(counter.getName(), counter);
            return counter;
        }
        if (counter.isCompatibleWith(oldCounter)) {
            Counter<?> compatibleCounter = oldCounter;
            return compatibleCounter;
        }
        String string = String.valueOf(counter);
        String string2 = String.valueOf(oldCounter);
        String string3 = String.valueOf(this);
        throw new IllegalArgumentException(new StringBuilder(45 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Counter ").append(string).append(" duplicates incompatible counter ").append(string2).append(" in ").append(string3).toString());
    }

    public boolean addCounter(Counter<?> counter) {
        return this.add(counter);
    }

    public synchronized Counter<?> getExistingCounter(String name) {
        return this.counters.get(name);
    }

    @Override
    public synchronized Iterator<Counter<?>> iterator() {
        return this.counters.values().iterator();
    }

    @Override
    public synchronized int size() {
        return this.counters.size();
    }

    @Override
    public synchronized boolean add(Counter<?> e) {
        if (null == e) {
            return false;
        }
        if (this.counters.containsKey(e.getName())) {
            return false;
        }
        this.counters.put(e.getName(), e);
        return true;
    }

    public class AddCounterMutator {
        public <T> Counter<T> addCounter(Counter<T> counter) {
            return CounterSet.this.addOrReuseCounter(counter);
        }
    }
}

