/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common;

import com.google.cloud.dataflow.sdk.util.common.PeekingReiterator;
import com.google.cloud.dataflow.sdk.util.common.Reiterator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class TaggedReiteratorList
extends AbstractList<Reiterator<Object>> {
    private final TagExtractor<Object> extractor;
    private final List<PeekingReiterator<Object>> starts = new ArrayList<PeekingReiterator<Object>>();
    private final int size;
    private static final PeekingReiterator<Object> EMPTY_TAIL = new PeekingReiterator<Object>(new Reiterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalArgumentException();
        }

        @Override
        public Reiterator<Object> copy() {
            throw new IllegalArgumentException();
        }
    });

    public <T> TaggedReiteratorList(Reiterator<T> taggedReiterator, TagExtractor<T> extractor) {
        this(taggedReiterator, extractor, -1);
    }

    public <T> TaggedReiteratorList(Reiterator<T> taggedReiterator, TagExtractor<T> extractor, int size) {
        this.starts.add(new PeekingReiterator<T>(taggedReiterator));
        this.extractor = extractor;
        this.size = size;
    }

    @Override
    public Reiterator<Object> get(int tag) {
        return new SubIterator(tag);
    }

    @Override
    public int size() {
        if (this.size == -1) {
            throw new UnsupportedOperationException();
        }
        return this.size;
    }

    private PeekingReiterator<Object> getStart(int tag) {
        if (tag >= this.starts.size()) {
            PeekingReiterator<Object> start = this.getStart(tag - 1);
            while (start.hasNext() && this.extractor.getTag(start.peek()) < tag) {
                start.next();
            }
            this.starts.add(start);
        }
        return this.starts.set(tag, (PeekingReiterator<Object>)this.starts.get(tag).copy());
    }

    private class SubIterator
    implements Reiterator<Object> {
        private final int tag;
        private PeekingReiterator<Object> iterator;

        private SubIterator(int tag) {
            this(tag, (PeekingReiterator<Object>)null);
        }

        private SubIterator(int tag, PeekingReiterator<Object> iterator) {
            this.tag = tag;
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (this.iterator == null) {
                this.iterator = TaggedReiteratorList.this.getStart(this.tag);
            }
            if (this.iterator.hasNext() && TaggedReiteratorList.this.extractor.getTag(this.iterator.peek()) == this.tag) {
                return true;
            }
            if (this.iterator != EMPTY_TAIL) {
                if (TaggedReiteratorList.this.starts.size() > this.tag + 1) {
                    TaggedReiteratorList.this.starts.set(this.tag + 1, this.iterator);
                } else {
                    TaggedReiteratorList.this.starts.add(this.tag + 1, this.iterator);
                }
                this.iterator = EMPTY_TAIL;
            }
            return false;
        }

        @Override
        public Object next() {
            if (this.hasNext()) {
                return TaggedReiteratorList.this.extractor.getValue(this.iterator.next());
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalArgumentException();
        }

        @Override
        public Reiterator<Object> copy() {
            return new SubIterator(this.tag, (PeekingReiterator<Object>)(this.iterator == null || this.iterator == EMPTY_TAIL ? this.iterator : this.iterator.copy()));
        }
    }

    public static interface TagExtractor<T> {
        public int getTag(T var1);

        public Object getValue(T var1);
    }
}

