/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common.worker;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.util.common.Reiterator;
import com.google.cloud.dataflow.sdk.util.common.worker.ShuffleBatchReader;
import com.google.cloud.dataflow.sdk.util.common.worker.ShuffleEntry;
import com.google.cloud.dataflow.sdk.util.common.worker.ShuffleEntryReader;
import com.google.cloud.dataflow.sdk.util.common.worker.ShufflePosition;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class BatchingShuffleEntryReader
implements ShuffleEntryReader {
    private final ShuffleBatchReader batchReader;

    public BatchingShuffleEntryReader(ShuffleBatchReader batchReader) {
        this.batchReader = Preconditions.checkNotNull(batchReader);
    }

    @Override
    public Reiterator<ShuffleEntry> read(@Nullable ShufflePosition startPosition, @Nullable ShufflePosition endPosition) {
        return new ShuffleReadIterator(startPosition, endPosition);
    }

    private final class ShuffleReadIterator
    implements Reiterator<ShuffleEntry> {
        @Nullable
        private final ShufflePosition endPosition;
        @Nullable
        private ShufflePosition nextStartPosition;
        @Nullable
        ShuffleBatchReader.Batch currentBatch;
        @Nullable
        private ListIterator<ShuffleEntry> entries;

        ShuffleReadIterator(@Nullable ShufflePosition startPosition, ShufflePosition endPosition) {
            this.nextStartPosition = startPosition;
            this.endPosition = endPosition;
        }

        private ShuffleReadIterator(ShuffleReadIterator it) {
            this.endPosition = it.endPosition;
            this.nextStartPosition = it.nextStartPosition;
            this.currentBatch = it.currentBatch;
            this.entries = it.entries == null ? null : it.currentBatch.entries.listIterator(it.entries.nextIndex());
        }

        @Override
        public boolean hasNext() {
            this.fillEntriesIfNeeded();
            return this.entries.hasNext();
        }

        @Override
        public ShuffleEntry next() throws NoSuchElementException {
            this.fillEntriesIfNeeded();
            ShuffleEntry entry = this.entries.next();
            return entry;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public ShuffleReadIterator copy() {
            return new ShuffleReadIterator(this);
        }

        private void fillEntriesIfNeeded() {
            if (this.entries != null && this.entries.hasNext()) {
                return;
            }
            if (this.entries != null && this.nextStartPosition == null) {
                Preconditions.checkState(!this.entries.hasNext());
                return;
            }
            do {
                this.fillEntries();
            } while (!this.entries.hasNext() && this.nextStartPosition != null);
        }

        private void fillEntries() {
            try {
                ShuffleBatchReader.Batch batch = BatchingShuffleEntryReader.this.batchReader.read(this.nextStartPosition, this.endPosition);
                this.nextStartPosition = batch.nextStartPosition;
                this.entries = batch.entries.listIterator();
                this.currentBatch = batch;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            Preconditions.checkState(this.entries != null);
        }
    }
}

