/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common.worker;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObservableIterable;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObservableIterator;
import com.google.cloud.dataflow.sdk.util.common.PeekingReiterator;
import com.google.cloud.dataflow.sdk.util.common.Reiterable;
import com.google.cloud.dataflow.sdk.util.common.Reiterator;
import com.google.cloud.dataflow.sdk.util.common.worker.KeyGroupedShuffleEntries;
import com.google.cloud.dataflow.sdk.util.common.worker.ProgressTracker;
import com.google.cloud.dataflow.sdk.util.common.worker.ProgressTrackerGroup;
import com.google.cloud.dataflow.sdk.util.common.worker.ProgressTrackingReiterator;
import com.google.cloud.dataflow.sdk.util.common.worker.ShuffleEntry;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public abstract class GroupingShuffleEntryIterator
implements Iterator<KeyGroupedShuffleEntries> {
    private PeekingReiterator<ShuffleEntry> shuffleIterator;
    @Nullable
    private byte[] currentKeyBytes = null;

    public GroupingShuffleEntryIterator(Reiterator<ShuffleEntry> shuffleIterator) {
        this.shuffleIterator = new PeekingReiterator<ShuffleEntry>(new ProgressTrackingReiterator<ShuffleEntry>(shuffleIterator, new ProgressTrackerGroup<ShuffleEntry>(){

            @Override
            protected void report(ShuffleEntry entry) {
                GroupingShuffleEntryIterator.this.notifyElementRead(entry.length());
            }
        }.start()));
    }

    protected abstract void notifyElementRead(long var1);

    @Override
    public boolean hasNext() {
        this.advanceIteratorToNextKey();
        return this.shuffleIterator.hasNext();
    }

    @Override
    public KeyGroupedShuffleEntries next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ShuffleEntry entry = this.shuffleIterator.peek();
        this.currentKeyBytes = entry.getKey();
        return new KeyGroupedShuffleEntries(entry.getPosition(), this.currentKeyBytes, new ValuesIterable(new ValuesIterator(this.currentKeyBytes)));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void advanceIteratorToNextKey() {
        ShuffleEntry entry;
        if (this.currentKeyBytes == null) {
            return;
        }
        while (this.shuffleIterator.hasNext() && Arrays.equals((entry = this.shuffleIterator.peek()).getKey(), this.currentKeyBytes)) {
            this.shuffleIterator.next();
        }
        this.currentKeyBytes = null;
    }

    static /* synthetic */ byte[] access$202(GroupingShuffleEntryIterator x0, byte[] x1) {
        x0.currentKeyBytes = x1;
        return x1;
    }

    private class ValuesIterator
    extends ElementByteSizeObservableIterator<ShuffleEntry>
    implements Reiterator<ShuffleEntry> {
        private final byte[] valueKeyBytes;
        private final PeekingReiterator<ShuffleEntry> valueShuffleIterator;
        private final ProgressTracker<ShuffleEntry> tracker;
        private boolean nextKnownValid = false;

        public ValuesIterator(byte[] valueKeyBytes) {
            this.valueKeyBytes = Preconditions.checkNotNull(valueKeyBytes);
            this.valueShuffleIterator = GroupingShuffleEntryIterator.this.shuffleIterator.copy();
            this.tracker = new ProgressTrackerGroup<ShuffleEntry>(){

                @Override
                protected void report(ShuffleEntry entry) {
                    ValuesIterator.this.notifyValueReturned(entry.length());
                }
            }.start();
        }

        private ValuesIterator(ValuesIterator it) {
            this.valueKeyBytes = it.valueKeyBytes;
            this.valueShuffleIterator = it.valueShuffleIterator.copy();
            this.tracker = it.tracker.copy();
            this.nextKnownValid = it.nextKnownValid;
        }

        @Override
        public boolean hasNext() {
            if (this.nextKnownValid) {
                return true;
            }
            if (!this.valueShuffleIterator.hasNext()) {
                return false;
            }
            ShuffleEntry entry = this.valueShuffleIterator.peek();
            this.nextKnownValid = Arrays.equals(entry.getKey(), this.valueKeyBytes);
            if (!this.nextKnownValid && this.valueKeyBytes == GroupingShuffleEntryIterator.this.currentKeyBytes) {
                GroupingShuffleEntryIterator.this.shuffleIterator = (PeekingReiterator)this.valueShuffleIterator.copy();
                GroupingShuffleEntryIterator.access$202(GroupingShuffleEntryIterator.this, null);
            }
            return this.nextKnownValid;
        }

        @Override
        public ShuffleEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ShuffleEntry entry = this.valueShuffleIterator.next();
            this.nextKnownValid = false;
            this.tracker.saw(entry);
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public ValuesIterator copy() {
            return new ValuesIterator(this);
        }
    }

    private static class ValuesIterable
    extends ElementByteSizeObservableIterable<ShuffleEntry, ValuesIterator>
    implements Reiterable<ShuffleEntry> {
        private final ValuesIterator base;

        public ValuesIterable(ValuesIterator base) {
            this.base = Preconditions.checkNotNull(base);
        }

        @Override
        public ValuesIterator createIterator() {
            return this.base.copy();
        }
    }
}

