/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common.worker;

import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.Operation;
import com.google.cloud.dataflow.sdk.util.common.worker.ReadOperation;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import com.google.cloud.dataflow.sdk.util.common.worker.StateSampler;
import com.google.cloud.dataflow.sdk.util.common.worker.WorkExecutor;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTaskExecutor
extends WorkExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(MapTaskExecutor.class);
    public final List<Operation> operations;
    protected final StateSampler stateSampler;

    public MapTaskExecutor(List<Operation> operations, CounterSet counters, StateSampler stateSampler) {
        super(counters);
        this.operations = operations;
        this.stateSampler = stateSampler;
    }

    @Override
    public void execute() throws Exception {
        LOG.debug("Executing map task");
        try (StateSampler.ScopedState state = this.stateSampler.scopedState(this.stateSampler.stateForName("other", StateSampler.StateKind.FRAMEWORK));){
            LOG.debug("Starting operations");
            ListIterator<Operation> iterator = this.operations.listIterator(this.operations.size());
            while (iterator.hasPrevious()) {
                Operation op = iterator.previous();
                op.start();
            }
            LOG.debug("Finishing operations");
            for (Operation op : this.operations) {
                op.finish();
            }
        }
        LOG.debug("Map task execution complete");
    }

    @Override
    public Reader.Progress getWorkerProgress() throws Exception {
        return this.getReadOperation().getProgress();
    }

    @Override
    public StateSampler.StateSamplerInfo getWorkerStateSamplerInfo() throws Exception {
        return this.stateSampler == null ? null : this.stateSampler.getInfo();
    }

    @Override
    public Reader.DynamicSplitResult requestDynamicSplit(Reader.DynamicSplitRequest splitRequest) throws Exception {
        return this.getReadOperation().requestDynamicSplit(splitRequest);
    }

    public ReadOperation getReadOperation() throws Exception {
        if (this.operations == null || this.operations.isEmpty()) {
            throw new IllegalStateException("Map task has no operation.");
        }
        Operation readOperation = this.operations.get(0);
        if (!(readOperation instanceof ReadOperation)) {
            throw new IllegalStateException("First operation in the map task is not a ReadOperation.");
        }
        return (ReadOperation)readOperation;
    }

    @Override
    public void close() throws Exception {
        this.stateSampler.close();
        super.close();
    }

    public boolean supportsRestart() {
        for (Operation op : this.operations) {
            if (op.supportsRestart()) continue;
            return false;
        }
        return true;
    }
}

