/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common.worker;

import com.google.cloud.dataflow.sdk.util.common.Counter;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObservable;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObserver;
import com.google.cloud.dataflow.sdk.util.common.worker.ElementCounter;
import java.util.Random;

public class OutputObjectAndByteCounter
implements ElementCounter {
    private final ElementByteSizeObservable<Object> elementByteSizeObservable;
    private final CounterSet.AddCounterMutator addCounterMutator;
    private Random randomGenerator = new Random();
    private static final int SAMPLING_TOKEN_UPPER_BOUND = 1000000;
    private static final int SAMPLING_CUTOFF = 10;
    private int samplingToken = 0;
    private Counter<Long> objectCount = null;
    private Counter<Long> byteCount = null;
    private Counter<Long> meanByteCount = null;
    private ElementByteSizeObserver byteCountObserver = null;
    private ElementByteSizeObserver meanByteCountObserver = null;
    private int samplingTokenUpperBound = 1000000;

    public OutputObjectAndByteCounter(ElementByteSizeObservable<?> elementByteSizeObservable, CounterSet.AddCounterMutator addCounterMutator) {
        this.elementByteSizeObservable = elementByteSizeObservable;
        this.addCounterMutator = addCounterMutator;
    }

    public OutputObjectAndByteCounter countObject(String objectCounterName) {
        this.objectCount = this.addCounterMutator.addCounter(Counter.longs(objectCounterName, Counter.AggregationKind.SUM));
        return this;
    }

    public OutputObjectAndByteCounter countBytes(String bytesCounterName) {
        if (this.elementByteSizeObservable != null) {
            this.byteCount = this.addCounterMutator.addCounter(Counter.longs(bytesCounterName, Counter.AggregationKind.SUM));
            this.byteCountObserver = new ElementByteSizeObserver(this.byteCount);
        }
        return this;
    }

    public OutputObjectAndByteCounter countMeanByte(String meanByteCounterName) {
        if (this.elementByteSizeObservable != null) {
            this.meanByteCount = this.addCounterMutator.addCounter(Counter.longs(meanByteCounterName, Counter.AggregationKind.MEAN));
            this.meanByteCountObserver = new ElementByteSizeObserver(this.meanByteCount);
        }
        return this;
    }

    public OutputObjectAndByteCounter setSamplingPeriod(int period) {
        this.samplingTokenUpperBound = period * 10;
        return this;
    }

    public Counter<Long> getObjectCount() {
        return this.objectCount;
    }

    public Counter<Long> getByteCount() {
        return this.byteCount;
    }

    public Counter<Long> getMeanByteCount() {
        return this.meanByteCount;
    }

    @Override
    public void update(Object elem) throws Exception {
        if (this.objectCount != null) {
            this.objectCount.addValue(1L);
        }
        if ((this.byteCountObserver != null || this.meanByteCountObserver != null) && (this.sampleElement() || this.elementByteSizeObservable.isRegisterByteSizeObserverCheap(elem))) {
            if (this.byteCountObserver != null) {
                this.byteCountObserver.setScalingFactor((double)Math.max(this.samplingToken, 10) / 10.0);
                this.elementByteSizeObservable.registerByteSizeObserver(elem, this.byteCountObserver);
            }
            if (this.meanByteCountObserver != null) {
                this.elementByteSizeObservable.registerByteSizeObserver(elem, this.meanByteCountObserver);
            }
            if (this.byteCountObserver != null && !this.byteCountObserver.getIsLazy()) {
                this.byteCountObserver.advance();
            }
            if (this.meanByteCountObserver != null && !this.meanByteCountObserver.getIsLazy()) {
                this.meanByteCountObserver.advance();
            }
        }
    }

    @Override
    public void finishLazyUpdate(Object elem) {
        if (this.byteCountObserver != null && this.byteCountObserver.getIsLazy()) {
            this.byteCountObserver.advance();
        }
        if (this.meanByteCountObserver != null && this.meanByteCountObserver.getIsLazy()) {
            this.meanByteCountObserver.advance();
        }
    }

    protected boolean sampleElement() {
        this.samplingToken = Math.min(this.samplingToken + 1, this.samplingTokenUpperBound);
        return this.randomGenerator.nextInt(this.samplingToken) < 10;
    }

    public OutputObjectAndByteCounter setRandom(Random random) {
        this.randomGenerator = random;
        return this;
    }
}

