/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common.worker;

import com.google.cloud.dataflow.sdk.util.common.worker.ElementCounter;
import com.google.cloud.dataflow.sdk.util.common.worker.Receiver;
import java.util.ArrayList;
import java.util.List;

public class OutputReceiver
implements Receiver {
    private final List<Receiver> outputs = new ArrayList<Receiver>();
    private final List<ElementCounter> outputCounters = new ArrayList<ElementCounter>();

    public void addOutput(Receiver receiver) {
        this.outputs.add(receiver);
    }

    public void addOutputCounter(ElementCounter outputCounter) {
        this.outputCounters.add(outputCounter);
    }

    @Override
    public void process(Object elem) throws Exception {
        for (ElementCounter counter : this.outputCounters) {
            counter.update(elem);
        }
        for (Receiver out : this.outputs) {
            if (out == null) continue;
            out.process(elem);
        }
        for (ElementCounter counter : this.outputCounters) {
            counter.finishLazyUpdate(elem);
        }
    }

    public int getReceiverCount() {
        return this.outputs.size();
    }

    public Receiver getOnlyReceiver() {
        if (this.outputs.size() != 1) {
            throw new AssertionError((Object)"only one receiver expected");
        }
        return this.outputs.get(0);
    }
}

