/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common.worker;

import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.OutputReceiver;
import com.google.cloud.dataflow.sdk.util.common.worker.ParDoFn;
import com.google.cloud.dataflow.sdk.util.common.worker.ReceivingOperation;
import com.google.cloud.dataflow.sdk.util.common.worker.StateSampler;

public class ParDoOperation
extends ReceivingOperation {
    public final ParDoFn fn;

    public ParDoOperation(String operationName, ParDoFn fn, OutputReceiver[] outputReceivers, String counterPrefix, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) {
        super(operationName, outputReceivers, counterPrefix, addCounterMutator, stateSampler);
        this.fn = fn;
    }

    @Override
    public void start() throws Exception {
        try (StateSampler.ScopedState start = this.stateSampler.scopedState(this.startState);){
            super.start();
            this.fn.startBundle(this.receivers);
        }
    }

    @Override
    public void process(Object elem) throws Exception {
        try (StateSampler.ScopedState process = this.stateSampler.scopedState(this.processState);){
            this.checkStarted();
            this.fn.processElement(elem);
        }
    }

    @Override
    public void finish() throws Exception {
        try (StateSampler.ScopedState finish = this.stateSampler.scopedState(this.finishState);){
            this.checkStarted();
            this.fn.finishBundle();
            super.finish();
        }
    }

    @Override
    public boolean supportsRestart() {
        return true;
    }
}

