/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common.worker;

import java.util.Arrays;

public class ShuffleEntry {
    final byte[] position;
    final byte[] key;
    final byte[] secondaryKey;
    final byte[] value;

    public ShuffleEntry(byte[] key, byte[] secondaryKey, byte[] value) {
        this.position = null;
        this.key = key;
        this.secondaryKey = secondaryKey;
        this.value = value;
    }

    public ShuffleEntry(byte[] position, byte[] key, byte[] secondaryKey, byte[] value) {
        this.position = position;
        this.key = key;
        this.secondaryKey = secondaryKey;
        this.value = value;
    }

    public byte[] getPosition() {
        return this.position;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getSecondaryKey() {
        return this.secondaryKey;
    }

    public byte[] getValue() {
        return this.value;
    }

    public int length() {
        return (this.key == null ? 0 : this.key.length) + (this.secondaryKey == null ? 0 : this.secondaryKey.length) + (this.value == null ? 0 : this.value.length);
    }

    public String toString() {
        String string = ShuffleEntry.byteArrayToString(this.position);
        String string2 = ShuffleEntry.byteArrayToString(this.key);
        String string3 = ShuffleEntry.byteArrayToString(this.secondaryKey);
        String string4 = ShuffleEntry.byteArrayToString(this.value);
        return new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("ShuffleEntry(").append(string).append(",").append(string2).append(",").append(string3).append(",").append(string4).append(")").toString();
    }

    public static String byteArrayToString(byte[] bytes) {
        return Arrays.toString(bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ShuffleEntry) {
            ShuffleEntry that = (ShuffleEntry)o;
            return (this.position == null ? that.position == null : Arrays.equals(this.position, that.position)) && (this.key == null ? that.key == null : Arrays.equals(this.key, that.key)) && (this.secondaryKey == null ? that.secondaryKey == null : Arrays.equals(this.secondaryKey, that.secondaryKey)) && (this.value == null ? that.value == null : Arrays.equals(this.value, that.value));
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() + (this.position == null ? 0 : Arrays.hashCode(this.position)) + (this.key == null ? 0 : Arrays.hashCode(this.key)) + (this.secondaryKey == null ? 0 : Arrays.hashCode(this.secondaryKey)) + (this.value == null ? 0 : Arrays.hashCode(this.value));
    }
}

