/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common.worker;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.cloud.dataflow.sdk.util.common.Counter;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class StateSampler
implements AutoCloseable {
    public static final long DEFAULT_SAMPLING_PERIOD_MS = 200L;
    private final String prefix;
    private final CounterSet.AddCounterMutator counterSetMutator;
    private ArrayList<Counter<Long>> countersByState = new ArrayList();
    private Map<String, Integer> statesByName = new HashMap<String, Integer>();
    private Map<Integer, StateKind> kindsByState = new HashMap<Integer, StateKind>();
    private volatile int currentState;
    private static final int DO_NOT_SAMPLE = -1;
    private volatile long stateTransitionCount;
    private long stateTimestampNs = 0L;
    private static final int NUM_EXECUTOR_THREADS = 16;
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(16, new ThreadFactoryBuilder().setDaemon(true).build());
    private Random rand = new Random();
    private List<SamplingCallback> callbacks = new ArrayList<SamplingCallback>();
    private ScheduledFuture<?> invocationTriggerFuture = null;
    private ScheduledFuture<?> invocationFuture = null;

    public StateSampler(String prefix, CounterSet.AddCounterMutator counterSetMutator, final long samplingPeriodMs) {
        this.prefix = prefix;
        this.counterSetMutator = counterSetMutator;
        this.currentState = -1;
        this.invocationTriggerFuture = executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long delay = StateSampler.this.rand.nextInt((int)samplingPeriodMs);
                if (StateSampler.this.invocationFuture != null) {
                    StateSampler.this.invocationFuture.cancel(false);
                }
                StateSampler.this.invocationFuture = executorService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        StateSampler.this.run();
                    }
                }, delay, TimeUnit.MILLISECONDS);
            }
        }, 0L, samplingPeriodMs, TimeUnit.MILLISECONDS);
        this.stateTimestampNs = System.nanoTime();
    }

    public StateSampler(String prefix, CounterSet.AddCounterMutator counterSetMutator) {
        this(prefix, counterSetMutator, 200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long startTimestampNs = System.nanoTime();
        int state = this.currentState;
        if (state != -1) {
            long elapsedMs = 0L;
            StateKind kind = null;
            ArrayList<SamplingCallback> copyOfCallbacks = new ArrayList<SamplingCallback>();
            StateSampler stateSampler = this;
            synchronized (stateSampler) {
                elapsedMs = TimeUnit.NANOSECONDS.toMillis(startTimestampNs - this.stateTimestampNs);
                kind = this.kindsByState.get(state);
                this.countersByState.get(state).addValue(elapsedMs);
                for (SamplingCallback c : this.callbacks) {
                    copyOfCallbacks.add(c);
                }
            }
            for (SamplingCallback c : copyOfCallbacks) {
                c.run(state, kind, elapsedMs);
            }
        }
        this.stateTimestampNs = startTimestampNs;
    }

    @Override
    public void close() {
        if (this.invocationTriggerFuture != null) {
            this.invocationTriggerFuture.cancel(false);
        }
        if (this.invocationFuture != null) {
            this.invocationFuture.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stateForName(String name, StateKind kind) {
        if (name.isEmpty()) {
            return -1;
        }
        Object object = this.prefix;
        String counterName = new StringBuilder(6 + String.valueOf(object).length() + String.valueOf(name).length()).append((String)object).append(name).append("-msecs").toString();
        object = this;
        synchronized (object) {
            StateKind originalKind;
            Integer state = this.statesByName.get(counterName);
            if (state == null) {
                Counter<Long> counter = this.counterSetMutator.addCounter(Counter.longs(counterName, Counter.AggregationKind.SUM));
                state = this.countersByState.size();
                this.statesByName.put(name, state);
                this.countersByState.add(counter);
                this.kindsByState.put(state, kind);
            }
            if ((originalKind = this.kindsByState.get(state)) != kind) {
                String string = String.valueOf((Object)kind);
                String string2 = String.valueOf((Object)originalKind);
                throw new IllegalArgumentException(new StringBuilder(67 + String.valueOf(name).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append("for state named ").append(name).append(", requested kind ").append(string).append(" different from the original kind ").append(string2).toString());
            }
            return state;
        }
    }

    public synchronized StateSamplerInfo getInfo() {
        return this.currentState == -1 ? null : new StateSamplerInfo(this.countersByState.get(this.currentState).getName(), this.stateTransitionCount, null);
    }

    public int setState(int state) {
        long previousStateTransitionCount = this.stateTransitionCount;
        this.stateTransitionCount = previousStateTransitionCount + 1L;
        int previousState = this.currentState;
        this.currentState = state;
        return previousState;
    }

    public int setState(String name, StateKind kind) {
        return this.setState(this.stateForName(name, kind));
    }

    public ScopedState scopedState(int state) {
        return new ScopedState(this, this.setState(state));
    }

    public synchronized void addSamplingCallback(SamplingCallback callback) {
        this.callbacks.add(callback);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static interface SamplingCallback {
        public void run(int var1, StateKind var2, long var3);
    }

    public class ScopedState
    implements AutoCloseable {
        private StateSampler sampler;
        private int previousState;

        private ScopedState(StateSampler sampler, int previousState) {
            this.sampler = sampler;
            this.previousState = previousState;
        }

        @Override
        public void close() {
            this.sampler.setState(this.previousState);
        }
    }

    public static class StateSamplerInfo {
        public final String state;
        public final Long transitionCount;
        public final Long stateDurationMillis;

        public StateSamplerInfo(String state, Long transitionCount, Long stateDurationMillis) {
            this.state = state;
            this.transitionCount = transitionCount;
            this.stateDurationMillis = stateDurationMillis;
        }
    }

    public static enum StateKind {
        USER,
        FRAMEWORK;

    }
}

